---
title: Overview · Cloudflare Vectorize docs
description: Vectorize is a globally distributed vector database that enables
  you to build full-stack, AI-powered applications with Cloudflare Workers.
  Vectorize makes querying embeddings — representations of values or objects
  like text, images, audio that are designed to be consumed by machine learning
  models and semantic search algorithms — faster, easier and more affordable.
lastUpdated: 2025-09-24T17:03:07.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/vectorize/
  md: https://developers.cloudflare.com/vectorize/index.md
---

Build full-stack AI applications with Vectorize, Cloudflare's powerful vector database.

Vectorize is a globally distributed vector database that enables you to build full-stack, AI-powered applications with [Cloudflare Workers](https://developers.cloudflare.com/workers/). Vectorize makes querying embeddings — representations of values or objects like text, images, audio that are designed to be consumed by machine learning models and semantic search algorithms — faster, easier and more affordable.

Vectorize is now Generally Available

To report bugs or give feedback, go to the [#vectorize Discord channel](https://discord.cloudflare.com). If you are having issues with Wrangler, report issues in the [Wrangler GitHub repository](https://github.com/cloudflare/workers-sdk/issues/new/choose).

For example, by storing the embeddings (vectors) generated by a machine learning model, including those built-in to [Workers AI](https://developers.cloudflare.com/workers-ai/) or by bringing your own from platforms like [OpenAI](#), you can build applications with powerful search, similarity, recommendation, classification and/or anomaly detection capabilities based on your own data.

The vectors returned can reference images stored in Cloudflare R2, documents in KV, and/or user profiles stored in D1 — enabling you to go from vector search result to concrete object all within the Workers platform, and without standing up additional infrastructure.

***

## Features

### Vector database

Learn how to create your first Vectorize database, upload vector embeddings, and query those embeddings from [Cloudflare Workers](https://developers.cloudflare.com/workers/).

[Create your Vector database](https://developers.cloudflare.com/vectorize/get-started/intro/)

### Vector embeddings using Workers AI

Learn how to use Vectorize to generate vector embeddings using Workers AI.

[Create vector embeddings using Workers AI](https://developers.cloudflare.com/vectorize/get-started/embeddings/)

### Search using Vectorize and AI Search

Learn how to automatically index your data and store it in Vectorize, then query it to generate context-aware responses using AI Search.

[Build a RAG with Vectorize](https://developers.cloudflare.com/ai-search/)

***

## Related products

**[Workers AI](https://developers.cloudflare.com/workers-ai/)**

Run machine learning models, powered by serverless GPUs, on Cloudflare’s global network.

**[R2 Storage](https://developers.cloudflare.com/r2/)**

Store large amounts of unstructured data without the costly egress bandwidth fees associated with typical cloud storage services.

***

## More resources

[Limits](https://developers.cloudflare.com/vectorize/platform/limits/)

Learn about Vectorize limits and how to work within them.

[Use cases](https://developers.cloudflare.com/use-cases/ai/)

Learn how you can build and deploy ambitious AI applications to Cloudflare's global network.

[Storage options](https://developers.cloudflare.com/workers/platform/storage-options/)

Learn more about the storage and database options you can build on with Workers.

[Developer Discord](https://discord.cloudflare.com)

Connect with the Workers community on Discord to ask questions, join the `#vectorize` channel to show what you are building, and discuss the platform with other developers.

[@CloudflareDev](https://x.com/cloudflaredev)

Follow @CloudflareDev on Twitter to learn about product announcements, and what is new in Cloudflare Developer Platform.
