---
title: Get started · Cloudflare Turnstile docs
description: This guide will get you started on setting up the Turnstile widget
  to protect your website from bots while maintaining a seamless user
  experience.
lastUpdated: 2025-10-03T20:30:58.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/turnstile/get-started/
  md: https://developers.cloudflare.com/turnstile/get-started/index.md
---

This guide will get you started on setting up the Turnstile widget to protect your website from bots while maintaining a seamless user experience.

## Prerequisites

Before you begin, you must have:

* A Cloudflare account
* A website or web application to protect
* Basic knowledge of HTML and your preferred server-side language

***

## Process

Turnstile widgets are the foundation of your bot protection implementation.

Each widget gets its own unique sitekey and secret key pair, and options for configurations.

| Component | Description |
| - | - |
| Sitekey | Public key used to invoke the Turnstile widget on your site. |
| Secret key | Private key used for server-side token validation. |
| Configurations | Mode, hostnames, appearance settings, and other options. |

Important

Regardless of how you create and manage your widgets, you will still need to [embed the widget](https://developers.cloudflare.com/turnstile/get-started/client-side-rendering/) on your webpage and [validate the token](https://developers.cloudflare.com/turnstile/get-started/server-side-validation/) on your server.

Implementing Turnstile involves two essential components that work together:

1. Client-side: [Embed the widget](https://developers.cloudflare.com/turnstile/get-started/client-side-rendering/)

   Add the Turnstile widget to your webpage to challenge visitors and generate verification tokens.

2. Server-side: [Validate the token](https://developers.cloudflare.com/turnstile/get-started/server-side-validation/)

   Verify the tokens on your server using the Siteverify API to ensure they are authentic and have not been tampered with.

Turnstile is designed to be an independent service. You can use Turnstile on any website, regardless of whether it is proxied through the Cloudflare network. This allows for flexible deployment across multi-cloud environments, on-premises infrastructure, or sites using other CDNs. The client-side widget and server-side validation steps are completely self-contained.

Refer to [Implementation](#implementation) below for guidance on how to implement Turnstile on your website.

***

## Implementation

Follow the steps below to implement Turnstile.

### 1. Create your widget

First, you must create a Turnstile widget to get your sitekey and secret key.

Select your preferred implementation method:

[Cloudflare dashboard ](https://developers.cloudflare.com/turnstile/get-started/widget-management/dashboard/)[API ](https://developers.cloudflare.com/turnstile/get-started/widget-management/api/)[Terraform](https://developers.cloudflare.com/turnstile/get-started/widget-management/terraform/)

### 2. Embed the widget

Add the Turnstile widget to your webpage forms and applications.

Refer to [Embed the widget](https://developers.cloudflare.com/turnstile/get-started/client-side-rendering/) to learn more about implicit and explicit rendering methods.

Testing

You can test your Turnstile widget on your webpage without triggering an actual Cloudflare Challenge by using a testing sitekey.

Refer to [Testing](https://developers.cloudflare.com/turnstile/troubleshooting/testing/) for more information.

### 3. Validate tokens

Implement server-side validation to verify the tokens generated by your widgets.

Refer to [Validate the token](https://developers.cloudflare.com/turnstile/get-started/server-side-validation/) to secure your implementation with proper token verification.

Testing

You can test the dummy token generated with testing sitekey via Siteverify API with the testing secret key. Your production secret keys will reject dummy tokens.

Refer to [Testing](https://developers.cloudflare.com/turnstile/troubleshooting/testing/) for more information.

## Additional implementation options

### Mobile configuration

Special considerations are necessary for mobile applications and WebView implementations.

Refer to [Mobile implementation](https://developers.cloudflare.com/turnstile/get-started/mobile-implementation/) for more information on mobile application integration.

### Migration from other CAPTCHAs

If you are currently using reCAPTCHA, hCaptcha, or another CAPTCHA service, Turnstile can be a drop-in replacement. You can copy and paste our script wherever you have deployed the existing script today.

Refer to [Migration](https://developers.cloudflare.com/turnstile/migration/) for step-by-step migration guidance from other CAPTCHA services.

***

## Security requirements

* Server-side validation is mandatory. It is critical to enforce Turnstile tokens with the Siteverify API. The Turnstile token could be invalid, expired, or already redeemed. Not verifying the token will leave major vulnerabilities in your implementation. You must call Siteverify to complete your Turnstile configuration. Otherwise, it is incomplete and will result in zeroes for token validation when viewing your metrics in [Turnstile Analytics](https://developers.cloudflare.com/turnstile/turnstile-analytics/).

* Tokens expire after 300 seconds (5 minutes). Each token can only be validated once. Expired or used tokens must be replaced with fresh challenges.

***

## Best practices

### Security

* Protect your secret keys. Never expose secret keys in client-side code.
* Rotate your keys regularly. Use API or dashboard to rotate secret keys periodically.
* Restrict your hostnames. Only allow widgets on domains that you control.
* Monitor the usage. Use analytics to detect unusual patterns.

### Operational

* Use descriptive names. Name widgets based on their purpose, such as "Login Form" or "Contact Page".
* Separate your environments. Use different widgets for development, staging, and production.
* Keep track of which widgets are used at which locations.
* Store your widget configurations in version control when using Terraform.
