---
title: Remove key file password · Cloudflare SSL/TLS docs
description: You cannot upload a custom certificate with a password-protected key file.
lastUpdated: 2024-08-20T19:58:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/remove-file-key-password/
  md: https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/remove-file-key-password/index.md
---

You cannot upload a custom certificate with a password-protected key file.

The process for removing the password depends on your operating system. The following examples remove the password from `example.com.key`.

Linux

1. Open a command console.

2. Go to the directory containing the `example.com.key` file.

3. Copy the original key.

   ```sh
   cp example.com.key temp.key
   ```

4. Run the following command (if using an ECDSA certificate, replace `rsa` with `ec`).

   ```sh
   openssl rsa -in temp.key -out example.com.key
   ```

5. When prompted in the console window, enter the original key password.

6. [Upload the file contents](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/uploading/#upload-a-custom-certificate) to Cloudflare.

Windows

1. Go to <https://indy.fulgan.com/SSL/> and download the latest version of OpenSSL for your x86 or x86\_64 operating system.

2. Open the `.zip` file and extract it.

3. Select **openssl.exe**.

4. In the command window that appears, run:

   ```sh
   rsa -in C:\Path\To\example.com.key -out key.pem
   ```

5. Enter the original key password when prompted by the **openssl.exe** command window.

6. [Upload](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/uploading/#upload-a-custom-certificate) the contents of the `key.pem` file to Cloudflare.
