---
title: Manage miscategorization reports · Cloudflare Security Center docs
description: This guide will show you how to manage miscategorization of
  reports. To complete this guide, you will need to generate an API token.
lastUpdated: 2025-02-04T11:54:13.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/security-center/intel-apis/manage-miscategorization-reports/
  md: https://developers.cloudflare.com/security-center/intel-apis/manage-miscategorization-reports/index.md
---

This guide will show you how to manage miscategorization of reports. To complete this guide, you will need to generate an [API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/).

1. Create an [API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) if you do not have one already.
2. Choose **Custom Token**.
3. Name the token, and grant permissions.
4. Send a `POST` request to the miscategorization [API endpoint](https://developers.cloudflare.com/api/resources/intel/subresources/miscategorizations/methods/create/). You can find an example below:

```json
export URL="https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/intel/miscategorization"
curl -X POST "$URL" \
     -H "Authorization: Bearer $TOKEN" \
     -H "Content-Type:application/json" \
--data '{
  "content_adds": [
  ],
  "content_removes": [
  ],
  "indicator_type": "domain",
  "ip": null,
  "security_adds": [
    115
  ],
  "security_removes": [
  ],
  "url": "cloudflare.com"
}'
```

You should receive a response with the value `"success": true`:

```json
{
  "result": "",
  "success": true,
  "errors": [],
  "messages": []
}
```

Once you send the request, the Cloudflare Support team will receive it and will be able to take action.
