---
title: FAQ · Cloudflare Registrar docs
description: Below you will find answers to our most commonly asked questions.
  If you cannot find the answer you are looking for, refer to the community page
  to explore more resources.
lastUpdated: 2025-10-06T13:23:32.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/registrar/faq/
  md: https://developers.cloudflare.com/registrar/faq/index.md
---

Below you will find answers to our most commonly asked questions. If you cannot find the answer you are looking for, refer to the [community page](https://community.cloudflare.com/) to explore more resources.

* [Domain transfers](#domain-transfers)
* [Domain registrations](#domain-registrations)
* [Domain restoration](#domain-restoration)
* [Domain deletions](#domain-deletions)
* [Domain management](#domain-management)
* [Billing](#billing)

## Domain transfers

### Why did my transfer fail?

Domain transfers sometimes fail. Refer to [Registrar: troubleshoot stalled domain transfers](https://developers.cloudflare.com/registrar/troubleshooting/) for more information on what might have happened and how to solve the issue.

If you cannot solve the issue, open a support ticket or contact your account team.

### Why did my domain's expiration date change after transferring it to Cloudflare?

ICANN requires that any transfer also extends the expiration date of your domain by at least one year — that is one year from your current expiration date, not one year from the date of transfer. For example, if you transfer a domain on October 10, 2021, but it expires on March 10, 2022, your new expiration date will be March 10, 2023.

Whenever a domain is first registered, the registrant purchases control of that domain for some number of years — up to 10 years. For example, a domain registered on October 8, 2020 will have an expiration date of October 8th in some year between 2021 and 2030, depending on the amount of years originally purchased.

Transferring a domain adds time to the current expiration date, unless your domain already has [10 years on the term](#if-i-registered-my-domain-for-10-years-at-another-registrar-will-i-gain-another-year-if-i-transfer-it-to-cloudflare).

### What happens to my nameservers when I transfer my domain to Cloudflare?

Cloudflare Registrar only supports transfers of domains that are active on a Cloudflare [full setup](https://developers.cloudflare.com/dns/zone-setups/full-setup/). Domains on Cloudflare use [nameservers assigned by Cloudflare](https://developers.cloudflare.com/dns/zone-setups/reference/nameserver-assignment/) to the associated account and those nameservers must remain in place for the domain to be Active.

### How can I see the status of my domain transfer?

Once you initiate a domain transfer, your previous registrar has five days to release the domain. In most cases, they will send you an email to confirm you want to transfer. If you actively acknowledge that email (through a link or the registrar's dashboard), they can process it immediately.

To see the progress of your transfer, go to the **Transfer domains** page in the Cloudflare dashboard to see a list of domain transfers that are in progress.

[Go to **Transfer domains**](https://dash.cloudflare.com/?to=/:account/registrar/transfer)

To accelerate the process, be sure to check with your old registrar how you can approve the transfer out.

Once successful, you will receive an email from Cloudflare and be able to manage the domain in the dashboard under **Overview** of that site.

### Why am I not allowed to transfer my domain?

ICANN prohibits domain transfers within 60 days of a change to the WHOIS data or registrar of a domain. If you modified your contact information, transferred registrars, or registered your domain in the last 60 days, Cloudflare will be unable to process your transfer immediately.

You can leave the domain **In Progress** and Cloudflare will wait until after the 60-day window passes to attempt to process the transfer.

Note

This information does not apply to `.uk` domains.

### Why am I not able to start a transfer?

If you have an [unverified email address](https://developers.cloudflare.com/fundamentals/user-profiles/verify-email-address/), you might experience issues when initiating a domain transfer.

### What happens if I enter the wrong auth code?

If you enter an incorrect auth code (also referred to as authentication code or authorization code), return to the **Domain Registration** page or the **Overview** for your site. You can use the available input field to reenter your authentication code.

### If I registered my domain for 10 years at another registrar, will I gain another year if I transfer it to Cloudflare?

No. A domain cannot have more than 10 years on the term. If you registered your domain for 10 years, you will get 10 years upon transferring it to Cloudflare.

***

## Domain registrations

### My domain's registration was not extended by one year after transferring to Cloudflare

When you transfer your domain to Cloudflare, the registry will extend your registration by one year. However, in one specific circumstance your transfer could result in you keeping your original expiration date.

When a domain expires, the registration enters the auto-renew grace period. During that time, you can renew the domain at your registrar to avoid losing it. If your domain expires at your current registrar, you renew it and then transfer to Cloudflare within 45 days, the registry can restrict the addition of an extra year.

Say you have `example.com` registered and it expires on December 10, 2021. You decide to renew it during the auto-renew grace period on December 20, 2021. That renewal extends the registration to December 20, 2022. You then transfer to Cloudflare on December 30, 2021. Since that transfer is within 45 days of the expiration, the registry may not add the year to your registration. When you transfer to Cloudflare or any registrar in this circumstance, your expiration can still remain December 20th, 2022.

If a year is not added to your registration, you have effectively paid twice for the same added year. Per ICANN rules, you are entitled to request a refund at your previous registrar.

### What Happens When a Domain Expires?

In summary, here is what will happen after a domain expires:

* **Day 0**: Expiration Date.
* **Day 1 - 30**: Grace Period (domain resolves normally).
* **Day 31 - 40**: Suspension Period (domains resolves to suspension page).
* **Day 41 - 70**: Redemption Period.
* **Day 71 - 75**: Pending Delete Period.

Cloudflare currently offers a 40-day grace period for most top-level domains (TLDs).

During this period you may renew/extend the domain at any time from within the dashboard but no further auto-renew attempts will be made. For the first 30 days of the grace period, the domain will continue to resolve as normal. On the 30th day after the expiration date, the domain will be suspended and a parked suspension page will be displayed. You may still renew the domain at any time during this suspension period. On the 40th day, the domain will enter the Redemption Period and will no longer resolve to any web page.

The redemption period lasts for 30 days. During this time, it may be possible to restore and renew the domain. A restore fee may apply in addition to the renewal fee. At the end of the 30 day redemption period, the domain will be placed in pending delete status for a period of five days, after which it will be released and made available for re-registration. The domain cannot be restored or renewed during this period.

If the domain is in a state where it can be restored, the Manage Domain page in the Registrar section of dash will display a message indicating the domain is restorable. You will then will be able to initiate the restore process directly from the dashboard.

Cloudflare does not guarantee against domain loss in the sense of fully indemnifying you for business losses if you lose your domain. However, mechanisms are in place to alert you of domain expiration and redemption grace periods should your domain expire. You can also elect to set up your domain registration to renew automatically. For an additional layer of control over your domains, refer to [Domain Protection Service](https://www.cloudflare.com/products/registrar/custom-domain-protection/).

***

## Domain restoration

### Which domains are eligible to be restored?

Domains that are in the Redemption Period and have an EPP status of redemptionPeriod may be restored. For most TLDs this will include domains that are between 40 and 70 days past expiration.

Currently `.uk` domains cannot be restored using this process. We are working on an alternative process for `.uk` domains and will provide additional information at a later date.

### Is there a fee to restore a domain?

Yes, in most cases there is a restore fee.

The amount varies depending on the TLD. The restore fee is separate from the renewal fee. You will be presented with both the restore and renewal fees before confirming they wish to proceed.

### Will the domain be renewed after the restore has completed?

Yes. We will attempt to renew the domain after the restore has been completed. While not common, it is possible for the renewal transaction to fail.

In the event of a failure, we will make several retry attempts. If we are unable to process the renewal after several retries, you will be presented with a message that you should contact support for assistance.

### How long does the restore process take?

The entire process can take a few minutes to complete.

There are multiple steps to the restore process, and each step must be completed in a specific sequence. These steps are performed automatically by the system. The UI will continue to poll for an updated status and will provide feedback as each step completes.

### What happens if the domain renewal fails?

The restore and the renewal are two distinct processes that happen sequentially.

In rare cases the domain may be successfully restored but the renewal fails. We will make several attempts to renew the domain. However, should all the renewals fail the customer may attempt to manually renew the domain or contact support so we may investigate the cause of the failure.

### Can a restore be reversed or refunded?

No. Once a restore has been completed it can not be reversed. It may be possible to delete the domain again but there are no refunds.

Note

Domain names should be released after a period of 75 days, although the exact deletion timeline is ultimately determined by the domain's registry. You should monitor the domain status to ascertain when it will become available for registration once again.

***

## Domain deletions

### Why am I unable to delete my Registrar domain?

A domain can only be deleted if all the following conditions are met:

* The user initiating the action is a Super Admin or Read/Write Administrator.
* The domain is not delete locked at the registry with either `clientDeleteProhibited` or `serverDeleteProhibited`.
* The domain is not already in `pendingDelete`, `redemptionPeriod`, or in `pendingTransfer`.
* The domain has not been administratively locked by Cloudflare. This typically occurs for legal reasons such as a UDRP filing or court order, but may also be the result of an abuse or payment investigation.
* The domain is NOT a .UK domain. .UK domains currently cannot be deleted at the registry.

If any of the above conditions are not met, the domain cannot be deleted.

### Who has permission to delete a domain registration?

Only Super Admins and Administrators with Read/Write access can initiate the deletion of a domain. Note that only Super Admins will receive the email with the delete token.

### Will I receive a refund for my deleted domain registration?

No. Refunds will not be issued for costs incurred by a domain registration.

### How do I get the domain deletion token?

The delete token is only sent to the Super Admins of the account. If the user requesting the deletion is not a Super Admin they will need to obtain the delete token from one of the Super Admins of the account.

### How long is the domain deletion token valid for?

The delete token is valid for 30 minutes. After the 30 minutes the code will expire and the user must restart the process.

### Will the domain be deleted immediately from my account?

If the domain is within 5 days of the initial registration, the domain will be immediately released by the registry and made available for re-registration. In this scenario the domain will be immediately removed from the registrar section of the account. You may need to refresh the page to force an update of the data.

If the domain is more than 5 days old, it will enter the redemption period and will remain in account until the redemption period expires and the registry releases the domain.

***

## Domain management

### How can I update my telephone number, email, name or address?

You can update both your default contact information and any individual Registrant, Administrator, Technical or Billing contact for your domain registrations by following [Registrant contact updates](https://developers.cloudflare.com/registrar/account-options/domain-contact-updates/). Details that may be updated include name, email, address, organization and telephone number.

### Can I change my nameservers?

No, you need to use Cloudflare's nameservers for domains on Cloudflare Registrar. If you need to use different nameservers, you will need to [move your domain to another Registrar](https://developers.cloudflare.com/registrar/account-options/transfer-out-from-cloudflare/).

You can create NS records in the DNS tab of your Cloudflare Dashboard if you need to [delegate a subdomain](https://developers.cloudflare.com/dns/manage-dns-records/how-to/subdomains-outside-cloudflare/) to another service provider.

***

## Billing

### How much does Cloudflare Registrar cost?

Refer to [What is Cloudflare Registrar](https://www.cloudflare.com/learning/dns/what-is-cloudflare-registrar/) for more information on pricing.

### When will I be billed?

You will be billed when you input your authorization code and initiate the transfer of your domain to Cloudflare. Currently, Cloudflare Registrar only uses the primary payment method for any associated transaction. Make sure to copy and paste the code to avoid mistakes. The transfer will not initiate if the code is incorrect.

### Is there a fee to transfer a .UK domain?

No, there is no fee to transfer a `.uk` domain. Also, an additional year is NOT added during the transfer process. However, if the domain is nearing the expiration date and is set to auto-renew, it may be automatically renewed shortly after the completion of the transfer.
