---
title: Securing data in use · Cloudflare Reference Architecture docs
description: Learn how Cloudflare's Remote Browser Isolation (RBI) works and
  secures data in use.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-in-use/
  md: https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-in-use/index.md
---

## Introduction

Data in use refers to data that is being actively interacted with, processed, or manipulated by applications, systems, or users. For organizations, protecting data in use can be a challenge as it must remain accessible and usable by applications and users who need it to fulfill their duties, yet still protected against unauthorized access or tampering.

Today, a vast majority of a user’s interactions with operationally-critical data takes place inside a modern Internet browser, which today enables entire client applications, such as email clients, word processors, and spreadsheets, to be served to an end-user. This also means no software needs to be installed on the device, and also makes user interactions, such as copy and paste, and downloading sensitive data, relatively easy. Such interactions can pose a persistent risk to organizations whose employees and contractors are working with critical and/or sensitive data every day.

One method to secure data in use is to leverage greater control over the browsers themselves, and how employees use them to access applications and data. Cloudflare has approached this by building a headless browser solution on top of our massive global edge network, called [Remote Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/) (RBI). When a user attempts to access, for example, a privately hosted resource, or a resource on the public Internet, instead of directly serving it to the user’s browser without any other safeguards, Cloudflare first renders the resource in a sandboxed environment hosted on the Cloudflare global network. Then, without any perceptible difference to the end-user, a small Javascript client is run within their local browser to safely and securely retrieve and render the remotely loaded web content using a novel, patented technology unique to Cloudflare, called Network Vector Rendering (NVR).

## Protecting data in use with Cloudflare RBI

Cloudflare RBI effectively creates an invisible “gap” between the web content a user is accessing and their device, in effect protecting the device and the network it is connected to from exploits and attacks. Unlike secure web gateways, antivirus software, or firewalls which rely on known threat patterns or signatures, RBI is a genuine zero trust mechanism. Because all requests made within a remotely loaded RBI instance go through the Cloudflare Secure Web Gateway, it's possible to enforce access policies to data and also inspect the traffic itself to enforce any data in transit policies.

Even more, organizations can enforce specific data in use access controls, like blocking the ability to download/upload, copy and paste, and print data.

Common policies used with RBI:

* Content category - [Social Networks](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/) (e.g. Facebook): Given the large volumes of data that popular social media platforms collect, these apps are an attractive target and yet another attack vector for malicious entities. RBI allows for limiting what data, especially if that data matches a DLP profile, from being pasted into these applications.
* Application - [Artificial Intelligence](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/) (e.g. ChatGPT): Generative AI tools can boost employee productivity, but understanding who is using them and for what is imperative at this stage of the generative AI evolution. Again, DLP profiles here can be applied to prevent the copy and pasting of sensitive data into public AI tools.
* Application - [SaaS](https://developers.cloudflare.com/cloudflare-one/traffic-policies/application-app-types/) (e.g. Salesforce, Zendesk, etc): These applications can often contain highly confidential data. RBI can be used to really lock down access for risky users that require some access, such as contractors or partners. Controls such as preventing printing, or even preventing any keyboard input at all, can result in third party users only looking at a read only view of the application, as if RBI is a pane of glass between the user and the data.

The following diagram visualizes a typical interaction between a user, RBI and a website such as ChatGPT.

![Figure 1: Text copy/paste blocked by Cloudflare RBI.](https://developers.cloudflare.com/_astro/securing-data-in-use-fig1.DERWxOEQ_Z17px9m.svg)

1. User attempts to login to ChatGPT, and the request goes via Cloudflare since the user is running our [device agent](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/) to maximize visibility and control of all traffic between the end user’s device and the resources being requested. [Clientless](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/) options are supported as well.
2. Cloudflare’s [Secure Web Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) (SWG) will first verify that the user is permitted to access ChatGPT.
3. Cloudflare’s patented Network Vector Rendering (NVR) process begins as a headless browser on our edge network starts and rasterizes the web app, which involves writing SKIA draw commands.
4. NVR intercepts those draw commands > tokenizes them > compresses them > encrypts them > and sends them to the local web browser.
5. Because this request is running isolated, the policy also enforces preventing the user from [copying and pasting](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/isolation-policies/#copy-from-remote-to-client) sensitive content to ChatGPT from their local machine. Additional [policy settings](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/isolation-policies/#policy-settings), such as ‘Disable printing’, ‘Disable upload / download’, and more are available as well.

## Related resources

* [Securing data in transit](https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-in-transit/)
* [Securing data at rest](https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-at-rest/)
