---
title: Glossary · Cloudflare Radar docs
description: This page provides a list of terms and concepts to help you
  understand Radar and the information shown.
lastUpdated: 2025-10-27T11:06:34.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/radar/glossary/
  md: https://developers.cloudflare.com/radar/glossary/index.md
---

This page provides a list of terms and concepts to help you understand Radar and the information shown.

## AI bot and crawler traffic

HTTP request activity from user agents associated with AI assistants, AI data scrapers, and AI search crawlers. This information is normalized to show trends in traffic volume, providing insights into the activity levels of AI-driven web interactions over time. User agents included in this analysis are derived from the AI-focused user agents listed in the [ai.robots.txt](https://github.com/ai-robots-txt/ai.robots.txt) repository.

## Application-level attacks

Layer 7 attack information based on mitigated requests, including the most frequent mitigation techniques as well as the trend of mitigated request volume over time. For the "Application layer attack volume" and "Mitigated traffic sources" graphs, the selected location or ASN is the source of the mitigated requests. For the "Application layer attack distribution" graph, the Origin Location graph shows where attacks targeting the selected location are coming from and the Target Location graph shows the target locations of attacks coming from the selected location. "Application layer attack distribution" insights are not available at an ASN level.

## Authentication methods

[SPF](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#spf), [DKIM](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#dkim), and [DMARC](https://developers.cloudflare.com/dns/manage-dns-records/reference/dns-record-types/#dmarc) are policy-driven email authentication methods and when used together, they help prevent spammers, phishers, and other unauthorized parties from sending emails on behalf of a domain they do not own. PASS is the share of processed messages that pass the associated checks. FAIL is the share of processed messages that fail the associated checks. NONE is the share of processed messages for which no associated policy could be found. Data for these metrics comes from Cloudflare’s email routing service.

## Autonomous systems

The Internet is a network of networks, and autonomous systems are the networks that make up the Internet. More specifically, an autonomous system (AS) is a large network or group of networks that has a unified routing policy - the process by which a path through one or more networks is chosen.

Data packets hop from one AS to another until they reach their final destination. Every computer or device that connects to the Internet is connected to an AS. ISPs have one or more ASes, and each AS is assigned an official Autonomous System Number (ASN) for use in Border Gateway Protocol (BGP) routing. For example, Cloudflare's ASN is AS13335. Learn more in the [Cloudflare Learning Center](https://www.cloudflare.com/learning/network-layer/what-is-an-autonomous-system/).

## BGP announcements

Border Gateway Protocol (BGP) is the routing protocol for the Internet. Much like the post office processing mail, BGP picks the most efficient routes for delivering Internet traffic. A BGP announcement is a way for an AS to say to another, "When you receive traffic to this network prefix, please send it to me". That message is then processed and (possibly) forwarded to other ASes, allowing for every AS in the path to learn where to send traffic to that network prefix. Learn more in the [Cloudflare Learning Center](https://www.cloudflare.com/learning/security/glossary/what-is-bgp/).

On Cloudflare Radar, we provide time series charts for both the volume of BGP messages announced by ASes and the total size of their announced IP address space. BGP message volume shows the level of overall routing activity for a given AS, while announced IP address space indicates the size of the networks a given AS operates over time. We represent the IP address space size with the number of minimum routable network prefix sizes, which are the number of /24 prefixes for IPv4 and /48s for IPv6. Correspondingly, a /24 prefix represents 256 IP addresses while a /48 represents 2^80 IP addresses.

## BGP route leaks

[BGP route leaks](https://www.rfc-editor.org/rfc/rfc7908.html) are defined as the propagation of routing announcements beyond their intended scope. In Cloudflare Radar, you can inspect the detected route leak events on the corresponding autonomous system number (ASN) pages. The columns in the table are defined as follows:

* `From`: The autonomous system (AS) from which the routes are learned from.
* `By`: The AS that leaked the routes, or the leaker.
* `To`: The AS that received and propagated the leaked routes.
* `Start` and `End`: The starting and ending time of a route leak event.
* `BGP Msgs.`: The number of BGP announcements that contain leaked routes.
* `Prefixes`: The number of IP prefixes a route leak event affects.
* `Origins`: The number of origin ASes a route leak event affects.
* `Vantage Points`: The number of route collectors that observed a route leak event.

Learn more about our route leak detection system design and usages in [How we detect route leaks and our new Cloudflare Radar route leak service](https://blog.cloudflare.com/route-leak-detection-with-cloudflare-radar/) blog post.

## BGP origin hijacks

[BGP origin hijack](https://www.cloudflare.com/learning/security/glossary/bgp-hijacking/) is one type of BGP anomaly where networks falsely announce ownership for groups of IP addresses (prefixes) that they do not own, control, or route to. A BGP origin hijack can redirect Internet traffic to the hijacker from its legitimate destination, causing data loss with potential leak of private/confidential information.

In Cloudflare Radar, you can inspect the detected BGP origin hijack events in the "BGP Origin Hijacks" table. The columns of the table are defined as follows:

* `ID`: Event ID, clickable and navigates to the event details page.
* `Detected Origin`: The AS that originated the prefixes at the time of detection, potentially being a BGP hijacker.
* `Expected Origin(s)`: The AS(es) that are expected to originate the corresponding prefixes based on various evidences.
* `Start Time (UTC)` and `Duration`: The detected timestamp in UTC with a human-readable time duration for how long the event lasted. Ongoing events will not have a duration value, indicated by the `--` sign.
* `BGP Messages`: The number of BGP messages that contain the detected anomaly.
* `Prefixes`: The prefixes hijacked during the event, showing only one full prefix due to table space limitation.
* `Confidence`: The level of confidence that we have on the event being a true hijacks. Values can be `High`, `Medium`, or `Low`.
* `Tags`: The relevant evidence presented as short tags, presenting key facts we compiled using additional data sources, such as RPKI validation results or network relationship.

You can also access the detection result programmatically via our [public API](https://developers.cloudflare.com/api/resources/radar/subresources/bgp/subresources/hijacks/subresources/events/methods/list/) ([CC BY-NC 4.0](https://creativecommons.org/licenses/by-nc/4.0/) license).

## BGP real-time routes

Cloudflare Radar's prefix routing page displays real-time BGP routes as a [Sankey diagram](https://en.wikipedia.org/wiki/Sankey_diagram). This visualization is built using MRT data from [RouteViews](https://www.routeviews.org/routeviews/) and [RIPE RIS](https://www.ripe.net/analyse/internet-measurements/routing-information-service-ris/), combined with real-time streams from RouteViews' Kafka instance and [RIS Live](https://ris-live.ripe.net/).

By default, the route visualization shows paths from the originating AS to [Tier-1 networks](https://en.wikipedia.org/wiki/Tier_1_network), omitting the segments from Tier-1 networks to BGP route collectors for clarity. Users can choose to see the complete paths using the "Show full paths" toggle.

Above the visualization, a table details the prefix origin, including the originating AS, its visibility percentage across route collectors, and [RPKI](https://blog.cloudflare.com/rpki-details/) validation status (`valid`, `invalid`, `unknown`).

Hovering over a link in the diagram reveals a tooltip with the connected ASNs, the observing BGP route collectors (from [RIPE RIS](https://ris.ripe.net/docs/route-collectors/) and [RouteViews](https://www.routeviews.org/routeviews/collectors/)), and the last update timestamp.

## Certificates

Encryption is a critical part of a safe Internet. SSL/TLS is the standard security technology for establishing an encrypted link between a client and a server.

In Cloudflare Radar, you can view all certificates issued for a given domain by a trusted Certificate Authority that are listed in active certificate transparency logs.

You can review the certificates issued for your domain name to ensure that there have been no incorrect or fraudulent issuances of certificates associated with your domains. You can also sign up to receive alerts from our certificate transparency monitor in the [Cloudflare Dashboard](https://dash.cloudflare.com/).

## Certificate Transparency

[Certificate Transparency (CT)](https://certificate.transparency.dev/) is an Internet security standard for monitoring and auditing the issuance of digital certificates issued by Certification Authorities (CAs). CT helps detect misissued or malicious certificates by requiring CAs to publicly log all certificates they issue in append-only, verifiable logs. These logs are monitored by various entities, including browsers and security researchers, to ensure transparency and trust in the certificate ecosystem.

Key entities in CT include:

* **CAs:** Organizations that issue certificates.
* **CT Logs:** Public, append-only logs where issued certificates are recorded.
* **Monitors:** Parties that check logs for correctness.

The data available in Cloudflare Radar is derived from the CT logs currently monitored by Cloudflare. This enables visibility into certificate issuance trends, distributions, and metadata across the web.

## Connection characteristics

Share of inbound connections to Cloudflare from mail transfer agents with the given characteristics. “IP Version” breaks down connections made over IPv4 and IPv6. “Encryption” breaks down connections made over an encrypted connection using TLS, and those made over an unencrypted connection, in the clear. Data for these metrics comes from Cloudflare’s email routing service.

## Connection quality

Connection quality metrics include download and upload speed, latency (round-trip time), and latency jitter (round-trip time stability), reflecting the best expected performance for specific countries or ASNs. These metrics are derived from speed tests initiated by end users on the [Cloudflare Speed Test website](https://speed.cloudflare.com/), aggregated over the previous 90 days. The underlying raw data is freely accessible for analysis through [Measurement Lab's BigQuery](https://blog.cloudflare.com/aim-database-for-internet-quality/).

In speed, latency, and jitter rankings, only countries where users run speed tests with sufficient regularity are included. Consequently, certain countries may be excluded from the rankings, even though their data can be found in other sections of Radar.

Cloudflare Speed Test measures latency multiple times over the course of the test. Measurements taken before a download or upload begins are aggregated into idle latency and jitter, while measurements taken while a download or upload is in progress are aggregated as loaded latency and jitter.

## Content categories

Cloudflare uses a variety of data sources to categorize domains. Using Cloudflare Radar, you can view the content categories associated with a given domain. Cloudflare customers using [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/) or [1.1.1.1 for Families](https://developers.cloudflare.com/1.1.1.1/setup/#1111-for-families) can decide to block certain categories, like "Adult Content", in addition to security threats like malware and phishing.

In some cases, a domain may be miscategorized. For example, a social media site might be categorized as "Shopping & Auctions". If you believe a domain is miscategorized, or a domain has not yet been categorized, please provide your suggested category using [this form](https://radar.cloudflare.com/domains/feedback) to bring it to our attention.

## DNS

The [Domain Name System (DNS)](https://www.cloudflare.com/learning/dns/what-is-dns/) is a network service that is most commonly used to translate human-readable domain names into numerical IP addresses that computers can use to talk to each other. It is an essential Internet service, and is also used to look up other network-related information.

The data displayed on Radar for DNS is based on aggregated and anonymized DNS lookups to Cloudflare's [1.1.1.1](https://developers.cloudflare.com/1.1.1.1/) public resolver service.

## DNS magnitude

DNS Magnitude is a metric originally developed by [nic.at](https://www.nic.at/media/files/pdf/dns-magnitude-paper-20200601.pdf) (PDF) to estimate a domain’s overall visibility on the Internet.

Instead of only counting the total number of DNS queries, DNS Magnitude incorporates a sense of how many unique clients send queries to domains within the TLD. This approach gives a more accurate picture of a TLD’s reach, since a small number of sources can generate a large number of queries. Our ranking is based on queries observed at Cloudflare’s [1.1.1.1](https://developers.cloudflare.com/1.1.1.1/) public resolver. We aggregate individual client IP addresses into subnets, referred to here as "networks".

The magnitude value ranges from 0 to 10, with higher values (closer to 10) indicating that the TLD is queried by a broader range of networks.

This reflects greater global visibility and, in some cases, a higher likelihood of name collision across different systems. [According to ICANN](https://www.icann.org/resources/pages/name-collision-2013-12-06-en), a name collision occurs when an attempt to resolve a name used in a private name space (such as under a non-delegated Top-Level Domain) results in a query to the public DNS. When the administrative boundaries of private and public namespaces overlap, name resolution may yield unintended or harmful results. For example, if ICANN were to delegate `.home`, that could cause significant issues for hobbyists that use the (currently non-delegated) TLD within their local networks.

## Domain rankings

Domain Rankings is based on our anonymized and aggregated [1.1.1.1 DNS resolver](https://developers.cloudflare.com/1.1.1.1/) data, complies with our [privacy policy](https://www.cloudflare.com/en-gb/privacypolicy/), and aims to identify the top most popular domains that reflect how people use the Internet globally. Domain Rankings’ popularity metric is best described as the estimated number of unique users that access a domain over some period of time.

Trending domains are domains which are currently experiencing an increase in popularity. Domains Trending Today are domains spiking in popularity, reflecting increased interest potentially related to a particular event or a topic. Domains Trending This Week are domains that have steadily grown in popularity, reflecting an increase of their user base over the week.

## Geographical distribution

Countries contributing traffic to this AS, and their relative contribution as percentage of the total AS traffic seen by Cloudflare.

## Internet outages

Internet connectivity can experience outages or disruptions due to a number of factors. These factors include power outages, damage to fiber optic cables, severe weather, natural disasters, or government directed shutdowns. Outages may be sub-national or national in geographic scope, or may impact one or more [ASNs](https://www.cloudflare.com/en-gb/learning/network-layer/what-is-an-autonomous-system/). Some outages may be brief, lasting just a few minutes, while others can stretch on for months — the duration can be related, in part, to the underlying cause. Internet outages listed in the Cloudflare Radar Outage Center are notable drops in traffic that have generally been corroborated with third party-information, which may include a social media or status page post from a telecommunications provider, a news report, or industry/community mailing lists.

An early warning signal that an Internet outage may be underway on a given network or in a given country is an anomalous drop in traffic as compared to historical traffic patterns and trends. Internet anomalies listed in the Cloudflare Radar Outage Center represent an algorithmically-observed anomalous drop in traffic for the listed entity. If a given entry is marked as verified, it means that we have manually corroborated the observed drop in traffic across multiple Cloudflare data sources and/or third-party sources such as [IODA](https://ioda.inetintel.cc.gatech.edu/), or third-party sources of information, such as those listed above. In the case of the latter, an associated Internet outage event will be opened, with the event listed in the Internet Outages table (and API).

## Internet services ranking

Internet services ranking is based on our anonymized and aggregated [1.1.1.1 DNS resolver](https://developers.cloudflare.com/1.1.1.1/) data, complies with our [privacy policy](https://www.cloudflare.com/en-gb/privacypolicy/), and aims to identify the top most popular Internet services that reflect how people use the Internet globally. A service represents one or more domains aggregated together. Ranking popularity metric is best described as the estimated number of unique users that access domains associated with a service, over some period of time.

## Internet traffic trends

Trends observed in Internet traffic originating globally or within a given location or autonomous system within the selected time range, based on aggregated data from our network.

## IP address geolocation

IP address geolocation is the term used for the process of associating an IP address with a location in the physical world. IP geolocation used on Cloudflare Radar comes from a third-party database.

Note that a number of factors may affect the accuracy of the geolocation information, including mobile network architecture, the use of VPN services, and the use of privacy-protecting proxy services.

Learn more from Cloudflare's documentation on [IP geolocation](https://developers.cloudflare.com/network/ip-geolocation/#report-an-incorrect-ip-location) about how to suggest a correction if you believe the location provided is incorrect.

## IPv6 adoption

The IPv4 vs. IPv6 graph shows the distribution of traffic by IP version, and is intended to highlight IPv6 adoption trends.

Note that prior to January 23, 2023, the IPv6 percentage shown in the chart was calculated as (IPv6 requests / IPv4+IPv6 requests). After that date, the IPv6 percentage is calculated as (IPv6 requests / requests for dual-stacked content).

## IQI

The Internet Quality Index estimates connection performance under average utilization, such as web browsing. It is based on end user measurements against a fixed set of Cloudflare and third-party targets, providing numbers for bandwidth, round-trip time (latency), and DNS response time, aggregated by continent, country, or ASN.

The IQI methodology requires a minimum number of measurements to generate estimates. As a result, graphs for smaller countries and ASNs may display occasional gaps, especially during nighttime. These gaps do not indicate outages. The number of measurements underlying IQI does not necessarily correlate with the volume of traffic observed by Cloudflare in a specific country or ASN.

## IRR AS-SETs

An IRR AS-SET is a named collection of Autonomous System Numbers (ASNs) within the Internet Routing Registry (IRR) used to define and manage BGP routing policies. By grouping related networks, such as customers and downstream peers, under a single identifier, network operators can automate the creation of BGP filters, which are essential for preventing the propagation of BGP route leaks. AS-SETs can be hierarchical, meaning they can include other AS-SETs as members, creating a scalable but complex structure. To quantify this complexity, the "AS Cone" measures the total number of unique ASNs in a fully expanded set (its downstream footprint), while "Upstreams" measures how many other AS-SETs include it directly or indirectly, providing insight into its role in the global routing system.

An AS-SET does not inherently includes its owner networks. Cloudflare Radar infers the owner by matching the AS-SET name on [PeeringDB](https://www.peeringdb.com/) or by the name itself. When an AS-SET's owner can be inferred via both methods, we prefer the PeeringDB information.

## Leaked credentials

[Leaked credentials detection](https://developers.cloudflare.com/waf/detections/leaked-credentials/) scans incoming HTTP requests for known authentication patterns from common web apps and any custom detection locations that were configured. Cloudflare Radar provides visibility into aggregate trends in authentication requests, including the detection of leaked credentials.

## Mobile operating systems

The Mobile Operating Systems graph shows the distribution of mobile device requests by operating system, representing trends observed in Internet traffic originating globally or within a given location or autonomous system within the selected time range, based on aggregated data from our network. "Mobile device" includes phones and tablets only, and does not include other types of devices, such as those classified as desktops/laptops, smart TVs, or gaming consoles.

## Most observed TLDs

[Top-level domains, also known as TLDs](https://www.cloudflare.com/learning/dns/top-level-domain/), are found in the right-most portion of a hostname. As of February 2024, there are nearly 1600 Top Level Domains listed in the [IANA Root Zone Database](https://www.iana.org/domains/root/db). On Radar, we are sharing our own perspective on these TLDs, highlighting those with the largest shares of spam and malicious emails. The analysis is based on the sending domain’s TLD, found in the `From:` header of an email message. Data for this metric comes from Cloudflare’s cloud email security service.

## Network-level DDoS attacks

Attacks mitigated by our Level 3 and 4 Denial of Service Attack prevention systems. We show the most used attack vectors as well as the change in attack volume over the selected time range. Selected location is the location of the data center(s) where the attacks were mitigated. Target industry and vertical categories are associated with the customers being attacked.

Industry categories include business types grouped by their primary activities, such as information technology and services, retail, or telecommunications. Vertical categories are high-level groupings that incorporate related industries, such as the "Internet and Telecom" vertical, which includes industries such as "Internet" and "Telecommunications".

Network-level DDoS attacks graphs are based on traffic measured in bytes.

## Post-quantum encryption adoption

The Post-Quantum Encryption Adoption graph shows the share of HTTPS requests to Cloudflare that are encrypted with post-quantum (PQ) cryptography. Additional details about Cloudflare's support for PQ cryptography can be found at [Cloudflare Research](https://pq.cloudflareresearch.com/).

## Robots.txt

A [robots.txt](https://www.cloudflare.com/learning/bots/what-is-robots-txt/) file contains instructions for bots that tell them which webpages they can and cannot access.

The data displayed for robots.txt is based on successfully parsed robots.txt files from the top 10,000 domains. From these files, we count the occurrences of each user agent under the `Allow` and `Disallow` directives. A user agent is classified as "fully allowed" or "fully disallowed" if the directive value is `*`. Otherwise, if the user agent is only allowed or disallowed to crawl specific paths, it is classified as "partially allowed" or "partially disallowed."

Currently, we only include AI-focused user agents listed in the [ai.robots.txt](https://github.com/ai-robots-txt/ai.robots.txt) repository.

## TCP resets and timeouts

In the Transmission Control Protocol (TCP), client-initiated connection resets (via the RST flag, TCP's "panic button") are atypical, and indicate to the server that *something went wrong* requiring the connection to be closed immediately. Similarly, connection timeouts (where the server closes a connection due to an unresponsive client) should not happen in conventional data exchanges. For comparison, a typical TCP connection consists of a 3-way handshake initiated by a client with a SYN packet to the server, then a data exchange moderated with ACK and PSH flags in the data packets, and finally a graceful close initiated from either side with a FIN packet. A FIN close is considered graceful because it ensures both sides complete their data transfer before closing the connection. In contrast, a timeout or RST flag triggers a hard stop, even if data is waiting to be sent or acknowledged. See [RFC 9293](https://datatracker.ietf.org/doc/html/rfc9293) for more details on the TCP protocol.

A TCP server may see timed-out or reset connections for a variety of reasons. Some are benign, such as client applications that lose connectivity or abruptly shut down (e.g., browsers cleaning up closed tabs or port scanners). Others are more concerning, such as [DoS attacks](https://www.cloudflare.com/learning/ddos/syn-flood-ddos-attack/) or third-party interference. In some cases, a close examination of the packets in a connection can help to shed light on the reason for termination. For example, [Global, Passive Detection of Connection Tampering](https://research.cloudflare.com/publications/SundaraRaman2023/) finds that certain packet patterns can be linked to middlebox connection tampering.

On Cloudflare Radar’s [Security & Attacks page](https://radar.cloudflare.com/security-and-attacks), you can view statistics on resets and timeouts from a sample of TCP connections to Cloudflare’s servers, broken down by how far the connection progressed before termination. The plot lines are defined as follows:

* **Post-SYN (mid-handshake)**: Connection resets or timeouts after the server received only a single SYN packet.
* **Post-ACK (immediately post-handshake)**: Connection resets or timeouts after the server received both a SYN packet and an ACK packet, meaning the connection was successfully established.
* **Post-PSH (after first data packet)**: Connection resets or timeouts after the server received a packet with PSH flag set, following connection establishment. The PSH flag indicates that the TCP packet contains data (such as a TLS Client Hello message) ready to deliver to the application.
* **Later (after multiple data packets)**: Connection resets within the first 10 packets from the client, but after the server has received multiple data packets.
* **None**: All other connections.

Learn more about the TCP resets and timeouts dataset in our [blog post](https://blog.cloudflare.com/tcp-resets-timeouts).

## Threat categories

Attackers use multiple types of techniques when carrying out email-based attacks, including links or attachments leading to malware; identity deception, where the message appears to be coming from a trusted contact; and brand impersonation, where the message appears to be coming from a trusted brand. Categories are assigned to the various types of threats found during the analysis of a malicious email message, and a single message can have multiple categories. These categories are aggregated into “Link”, “Attachment”, “Impersonation”, and “Other” groupings. “Link” groups individual threat types where the attacker is trying to get the user to click on something, “Attachment” groups individual threat types where the attacker has attached a file to the email message, and “Impersonation” groups individual threat types where the attacker is impersonating a trusted brand or contact. The “Other” grouping includes other threat types not covered by the previous three. The percentages represent the share of malicious email messages where the given threat categories have been found. Data for this metric comes from Cloudflare’s cloud email security service.

## Threat classification

Malicious email messages may be part of a phishing campaign, where recipients are tricked into sharing personal information like login details, or they are an attempt to spread malware through embedded images, links, or attachments. The percentage shown represents the share of processed messages that are classified as malicious. Data for this metric comes from Cloudflare’s cloud email security service.

## Traffic type filter

* **Human Only Traffic**: Traffic that our algorithms determine as being generated by human activity.

* **Automated Only Traffic**: Traffic that our algorithms determine as being generated by bot or automated script activity.

* **All Traffic**: Use all traffic, which includes both human activity and automated activity.

## Trends

Based on the aggregated HTTP/s metadata we see, we are able to show trends about a diverse set of metrics, including the distribution of mobile device vs. desktop traffic, the percentage of traffic detected as coming from bots, and the distribution of user agents/browsers. We also provide insights into the usage of HTTPS and IPv6.

## Verified bots

Bot traffic describes any non-human traffic to a website or an app. Some bots are useful, such as search engine bots that index content for search or customer service bots that help users. Other bots may be used to perform malicious activities, such as break into user accounts or scan the web for contact information to send spam.

Verified bots, such as the ones from search engines, are usually transparent about who they are. Cloudflare manually approves well-behaved services that benefit the broader Internet and honor robots.txt.

Each entry on the Verified Bots list exists because a corresponding IP address was seen associated with a verified bot in the last 30 days. A verified bot is not necessarily good or bad.

## Visitor location

The data displayed on domain-specific geographic traffic patterns is based solely on data from our recursive DNS services. All data displayed is in accordance with our privacy policies and commitments. This data may include attack traffic and cross-origin requests.

## Web crawlers

[Web crawlers](https://www.cloudflare.com/learning/bots/what-is-a-web-crawler/) are a type of bot that browses the Internet to collect and index website content. They are used by search engines like Google or Bing to make pages discoverable in search results.

They are also used by AI platforms, either to gather content for training large language models, or to retrieve up-to-date information for AI assistants. In both search and AI cases, crawlers work by following links from one page to another, creating a map of online content.

Radar's crawl-to-refer ratio metric is calculated by first mapping crawl requests for HTML pages based on the `User-Agent` header, and referral requests for HTML pages based on the `Referer` header, by platform (e.g., the ratio for Google is based on crawl requests from Googlebot, and referral requests from Google platforms). As with other traffic metrics on Radar, the aggregation resolution for the ratio data is based on the length of the selected timeframe. Additionally, note that traffic referred by native apps may not include a `Referer` header. As such, because the referral counts only include traffic from Web-based tools, these calculations may overstate the respective ratios, but it is unclear by how much.

## WHOIS

WHOIS is a standard for publishing the contact and nameserver information for all registered domains. Each registrar maintains their own WHOIS service. Anyone can query the registrar's WHOIS service to reveal the data behind a given domain.

## Workers AI

[Workers AI](https://developers.cloudflare.com/workers-ai/) allows you to run machine learning models, on the Cloudflare network, from your own code -- whether that be from Workers, Pages, or anywhere via the Cloudflare API. The data displayed for Workers AI is based on the number of Cloudflare accounts using a model during a specific time interval.
