---
title: Tutorials · Pulumi docs
description: Before you begin, make sure you install Pulumi.
lastUpdated: 2024-09-04T14:10:21.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/pulumi/tutorial/
  md: https://developers.cloudflare.com/pulumi/tutorial/index.md
---

Before you begin, make sure you [install Pulumi](https://developers.cloudflare.com/pulumi/installing/).

1. [Add a Site](https://developers.cloudflare.com/pulumi/tutorial/add-site/)

   * Bring your existing site under Cloudflare with Pulumi IaC.
   * Introduction of `pulumi new`, `up`, and `destroy`.
   * Cloudflare resources defined: Zone and DNS records.

2. [Manage secrets](https://developers.cloudflare.com/pulumi/tutorial/manage-secrets/)

   * Develop Workers securely with Pulumi ESC and Wrangler.
   * Introduction to the ESC CLI and the Wrangler CLI.
   * Manage Cloudflare credentials, Worker secrets, and `.dev.vars`.

3. [Deploy a Worker](https://developers.cloudflare.com/pulumi/tutorial/hello-world/)

   * Brief introduction to deploying a Cloudflare Workers application with Pulumi.
   * Introduction of `pulumi new`, `up`, and `destroy`.
   * Cloudflare resources defined: Worker script, Worker route, and DNS record.
