---
title: Breakout traffic · Cloudflare Magic WAN docs
description: Breakout traffic allows you to define which applications should
  bypass Cloudflare's security filtering.
lastUpdated: 2025-10-20T15:16:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/application-based-policies/breakout-traffic/
  md: https://developers.cloudflare.com/magic-wan/configuration/connector/network-options/application-based-policies/breakout-traffic/index.md
---

Breakout traffic allows you to define which applications should bypass Cloudflare's security filtering, and go directly to the Internet. It works via DNS requests inspection. This means that if your network is caching DNS requests, Breakout traffic will only take effect after you cache entries expire and your client issues a new DNS request that Magic WAN Connector can detect. This can take several minutes.

Warning

Breakout traffic will not work for applications that use DNS-over-HTTPS.

```mermaid
		flowchart LR
		accTitle: In this example, the applications go directly to the Internet, skipping Cloudflare's security. filtering
		a(Magic WAN Connector) --> b(Cloudflare) -->|Filtered traffic|c(Internet)

		a-- Breakout traffic ---d(Application1) & e(Application2) --> c

		classDef orange fill:#f48120,color: black
		class a,b orange
		
```

*In the graph above, Applications 1 and 2 are configured to bypass Cloudflare's security filtering, and go straight to the Internet*

A note on security

We recommend [routing](https://www.cloudflare.com/learning/network-layer/what-is-routing/) all traffic through our global network for comprehensive security filtering and access controls. However, there may be specific cases where you want a subset of traffic to bypass Cloudflare's security filtering and route it directly to the Internet. You can scope this breakout traffic to specific applications from the Cloudflare dashboard.

Refer to [Traffic steering](https://developers.cloudflare.com/magic-wan/reference/traffic-steering/) to learn how Cloudflare routes traffic.

## Add an application to your account

Before you can add or remove Breakout traffic applications to your Magic WAN Connector, you need to create an account-level list with the applications that you want to configure. Currently, adding to or modifying this list is only possible via API, through the [`managed_app_id`](https://developers.cloudflare.com/api/resources/magic_transit/subresources/apps/methods/create/) endpoint.

To add applications to your account:

Send a `POST` request to add new apps to your account.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Magic WAN Write`
* `Magic Transit Write`

```bash
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/apps" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "managed_app_id": "<APP_ID>",
    "name": "<APP_NAME>",
    "type": "<APP_TYPE>"
  }'
```

```json
{
  "result": {
    "account_app_id": "eb09v665c0784618a3e4ba9809258fd4",
    "name": "<APP_NAME>",
    "type": "<APP_TYPE>",
  },
  "success": true,
  "errors": [],
  "messages": []
}
```

You can now add this new app to the Breakout traffic list in your Magic WAN Connector.

### Add an application to Magic WAN Connector

You need to configure Breakout traffic applications for each of your existing sites, as this is a per-site configuration.

* Dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login), and select your account.
  2. Select **Magic WAN** > **Connector on-ramps (beta)**.

  1) Select the Connector you want to configure > **Edit**.
  2) Select **Traffic Steering**.
  3) In **Breakout traffic**, select **Add**.
  4) Select one or more applications that should bypass Cloudflare filtering from the list. You can also use the search box.
  5) Select **Save**.

  The traffic for the application you chose will now go directly to the Internet and bypass Cloudflare's filtering.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  1. Send a `GET` [request](https://developers.cloudflare.com/api/resources/magic_transit/subresources/apps/methods/list/) to list the applications associated with an account.

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Magic WAN Write`
     * `Magic WAN Read`
     * `Magic Transit Read`
     * `Magic Transit Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/apps" \
       --request GET \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
     ```

     ```json
       {
         "result": [
           {
             "managed_app_id": "<APP_ID>",
             "name": "<APP_NAME>",
             "type": "File Sharing",
             "hostnames": [
               "<app_name.com>",
               "<app-name.info>"
             ]
           }
         ]
       }
     ```

     Take note of the `"managed_app_id"` value for any application you want to add.

  2. Send a `POST` request to add new apps to the Breakout traffic policy.

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Magic WAN Write`
     * `Magic Transit Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/sites/$SITE_ID/app_configs" \
       --request POST \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
       --json '{
         "managed_app_id": "<MANAGED_APP_ID>",
         "breakout": true
       }'
     ```

     ```json
     {
       "result": {
         "account_app_id": "<APP_ID>",
         "name": "<APP_NAME>",
         "type": "<BREAKOUT_OR_PRIORITY>"
       },
       "success": true,
       "errors": [],
       "messages": []
     }
     ```

### Delete an application from Magic WAN Connector

* Dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login), and select your account.
  2. Select **Magic WAN** > **Connector on-ramps (beta)**.

  1) Select the Connector you want to configure > **Edit**.
  2) Select **Traffic Steering**.
  3) In **Breakout traffic**, find the application you want to delete > select the **three dots** next to it > **Remove**.
  4) (Optional) If you have several pages of applications, you can use the search box to quickly find the application you are looking for.

* API

  Note

  You will need your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and [API Key](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#view-your-global-api-key) to use the API.

  You need to delete Breakout traffic applications for each of your existing sites, as this is a per-site configuration.

  1. Send a [`GET` request](https://developers.cloudflare.com/api/resources/magic_transit/subresources/apps/methods/list/) to list the applications associated with a site.

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Magic WAN Write`
     * `Magic WAN Read`
     * `Magic Transit Read`
     * `Magic Transit Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/magic/sites/$SITE_ID/app_configs" \
       --request GET \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
     ```

     ```json
       {
         "result": [
           {
             "id": "<APP_ID>",
             "site_id": "<SITE_ID>",
             "managed_app_id": "<APP_NAME>",
             "breakout": true
           }
         ]
       }
     ```

     Take note of the `"id"` value for the application that want to delete.

  2. Send a `DELETE` request to delete an application from the Breakout traffic policy.

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/%7Baccount_id%7D/magic/sites/%7Bsite_id%7D/app_configs/%7Bid%7D" \
       --request DELETE
     ```

     ```json
     {
         "result": {
             "id": "<APP_ID>",
             "site_id": "<SITE_ID>",
             "managed_app_id": "<APP_NAME>",
             "breakout": true
         },
         "success": true,
         "errors": [],
         "messages": []
     }
     ```

## WARP traffic

If you have Magic WAN Connector and WARP clients deployed in your premises, Magic WAN Connector automatically routes WARP traffic to the Internet rather than Magic WAN IPsec tunnels. This prevents traffic from being encapsulated twice.

You may need to configure your firewall to allow this new traffic. Make sure to allow the following IPs and ports:

* **Destination IPs**: `162.159.193.0/24`, `162.159.197.0/24`
* **Destination ports**: `443`, `500`, `1701`, `2408`, `4443`, `4500`, `8095`, `844`

Refer to [WARP with firewall](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/) for more information on this topic.
