---
title: Update tunnel health checks frequency · Cloudflare Magic Transit docs
description: By default, Cloudflare servers send health checks to each GRE, CNI,
  or IPsec tunnel endpoint you configure to receive traffic from Magic Transit.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-transit/network-health/update-tunnel-health-checks-frequency/
  md: https://developers.cloudflare.com/magic-transit/network-health/update-tunnel-health-checks-frequency/index.md
---

By default, Cloudflare servers send [health checks](https://developers.cloudflare.com/magic-transit/reference/tunnel-health-checks/) to each GRE, CNI, or IPsec tunnel endpoint you configure to receive traffic from Magic Transit.

You can configure the health check frequency via the dashboard or [the API](https://developers.cloudflare.com/api/resources/magic_transit/subresources/gre_tunnels/methods/update/) to suit your use case. For example, if you are connecting a lower-traffic site for which you do not need immediate failover and would rather receive a lower volume of health check traffic, you should set the frequency to `low`. On the other hand, if you are connecting a site that is extremely sensitive to any issues, and you want a more proactive failover at the earliest sign of a potential problem, you should set this to `high`.

Available options are `low`, `mid`, and `high`.

* Dashboard

  1. Refer to [Add tunnels](https://developers.cloudflare.com/magic-transit/how-to/configure-tunnel-endpoints/#add-tunnels) to learn how to create or edit your tunnel.
  2. Change the **Health check rate** to your desired rate. For example, *Low*.
  3. Save your changes.

* API

  You can adjust the health check frequency by updating your [GRE](https://developers.cloudflare.com/api/resources/magic_transit/subresources/gre_tunnels/methods/update/), [IPsec](https://developers.cloudflare.com/api/resources/magic_transit/subresources/ipsec_tunnels/methods/update/), or [CNI](https://developers.cloudflare.com/api/resources/magic_transit/subresources/cf_interconnects/methods/update/) tunnels.

  Below is an example of how to adjust tunnel health check frequency to `low`. Note that this command applies to GRE, IPsec and CNI tunnels:

  ```bash
  curl "https://api.cloudflare.com/client/v4/accounts/%7Baccount_id%7D/magic/ipsec_tunnels/%7Bipsec_tunnel_id%7D" \
    --request PUT \
    --json '{
      "health_check": {
          "rate": "low"
      }
    }'
  ```

Note

Magic Transit customers with [Customer Metadata Boundary](https://developers.cloudflare.com/data-localization/metadata-boundary/) enabled for the European Union are able to access GRE, IPsec, and CNI health check and traffic volume data in the Cloudflare dashboard and via API. This ensures that any Magic Transit customers that need to be GDPR compliant are able to access all Magic Transit features.
