---
title: Network health · Cloudflare Magic Transit docs
description: Magic Transit uses health checks probes to determine the status of
  tunnels. This information is used to steer traffic through the best available
  route, and to warn you about potential issues with a tunnel. Service-level
  indicators (SLI) and service-level objectives (SLOs) combine to determine when
  Cloudflare sends you tunnel health alerts. Refer to How Cloudflare calculates
  Magic Tunnel health alerts for more information about SLI and SLOs.
lastUpdated: 2025-07-18T15:06:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-transit/network-health/
  md: https://developers.cloudflare.com/magic-transit/network-health/index.md
---

Magic Transit uses health checks probes to determine the status of tunnels. This information is used to steer traffic through the best available route, and to warn you about potential issues with a tunnel. Service-level indicators (SLI) and service-level objectives (SLOs) combine to determine when Cloudflare sends you tunnel health alerts. Refer to [How Cloudflare calculates Magic Tunnel health alerts](https://developers.cloudflare.com/magic-transit/reference/how-cloudflare-calculates-magic-tunnel-health-alerts/) for more information about SLI and SLOs.

There are two types of health checks available: endpoint and tunnel health checks.

* Endpoint health checks evaluate connectivity from Cloudflare distributed data centers to your origin network. Designed to provide a broad picture of Internet health, endpoint probes flow over available tunnels and do not inform tunnel selection or steering logic.

  Cloudflare global network servers issue endpoint health checks outside of customer network namespaces and typically target endpoints beyond the tunnel-terminating border router.

  During onboarding, you specify IP addresses to configure endpoint health checks.

* Tunnel health checks monitor the status of the tunnels that route traffic from Cloudflare to your origin network. Magic Transit relies on health checks to steer traffic to the best available routes.

  During onboarding, you specify the tunnel endpoints or tunnel health check targets the tunnel probes originating from Cloudflare's global network will target.

  Tunnel health check results are exposed via API. These results are aggregated from individual health check results done on Cloudflare servers.

Refer to [Tunnel health checks](https://developers.cloudflare.com/magic-transit/reference/tunnel-health-checks/) for a deep dive on the different type of health checks, what they do and how they work.

Note

Magic Transit customers with [Customer Metadata Boundary](https://developers.cloudflare.com/data-localization/metadata-boundary/) enabled for the European Union are able to access GRE, IPsec, and CNI health check and traffic volume data in the Cloudflare dashboard and via API. This ensures that any Magic Transit customers that need to be GDPR compliant are able to access all Magic Transit features.

Refer to the pages below for details on how to use the various network health checks available.

* [Run endpoint health checks (beta)](https://developers.cloudflare.com/magic-transit/network-health/run-endpoint-health-checks/)
* [Check tunnel health in the dashboard](https://developers.cloudflare.com/magic-transit/network-health/check-tunnel-health-dashboard/)
* [Update tunnel health checks frequency](https://developers.cloudflare.com/magic-transit/network-health/update-tunnel-health-checks-frequency/)
* [Configure Magic Tunnel health alerts](https://developers.cloudflare.com/magic-transit/network-health/configure-magic-tunnel-health-alerts/)
* [How Cloudflare calculates Magic Tunnel health alerts](https://developers.cloudflare.com/magic-transit/reference/how-cloudflare-calculates-magic-tunnel-health-alerts/)
