---
title: Next steps · Cloudflare Learning Paths
description: "Now that you have learned how Email security can protect your
  inbox from phishing attacks, refer to the following resources to onboard and
  enhance your email security posture:"
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/cybersafe/email-security-onboarding/email-security-next-steps/
  md: https://developers.cloudflare.com/learning-paths/cybersafe/email-security-onboarding/email-security-next-steps/index.md
---

Now that you have learned how Email security can protect your inbox from phishing attacks, refer to the following resources to onboard and enhance your email security posture:

| Resource | Description |
| - | - |
| [Phish submissions](https://developers.cloudflare.com/cloudflare-one/email-security/settings/phish-submissions/) | As part of your continuous email security posture, administrators and security analysts need to submit missed phish samples so Cloudflare can process them and take necessary action. |
| [API integration](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/api/) | Onboard your domain via API deployment. |
| [Impersonation registry](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/impersonation-registry/) | The impersonation registry contains combinations of emails of users who are likely to be impersonated. |
| [Trusted domains](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/trusted-domains/) | Trusted domains allows you to identify domains that should be exempted from Email security detections. |
| [Allow policies](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/allow-policies/) | Allow policies exempt messages that match certain patterns from normal detection scanning. |
| [Blocked senders](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/blocked-senders/) | Blocked senders can mark all messages from specific senders with a `MALICIOUS` disposition. |
| [PhishGuard](https://developers.cloudflare.com/cloudflare-one/email-security/phishguard/) | PhishGuard is a managed email security service that provides resources for end-to-end phish and targeted attack management and response. |
