---
title: Audit Logs - version 2 (beta) · Cloudflare Fundamentals docs
description: Cloudflare Audit Logs are account-based. All user-initiated actions
  are recorded automatically across both the Cloudflare API and dashboard.
  System-initiated logs are also captured to reflect actions taken automatically
  by Cloudflare systems, such as configuration updates, background processes, or
  internal policy enforcement.
lastUpdated: 2025-10-03T19:55:04.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/account/account-security/audit-logs/
  md: https://developers.cloudflare.com/fundamentals/account/account-security/audit-logs/index.md
---

Cloudflare Audit Logs are account-based. All user-initiated actions are recorded automatically across both the Cloudflare API and dashboard. System-initiated logs are also captured to reflect actions taken automatically by Cloudflare systems, such as configuration updates, background processes, or internal policy enforcement.

When a user-initiated action triggers additional automated behavior, corresponding system-initiated logs may be generated. In some cases, these system-initiated logs include additional enrichments that provide more context about what was changed, offering deeper visibility into the full lifecycle of the action.

When an action occurs, it is streamed through Cloudflare's audit logging pipeline and stored. This ensures consistent visibility into activity across all products.

For more detailed information about how the user-initiated actions are logged automatically, refer to the [Cloudflare Blog](https://blog.cloudflare.com/introducing-automatic-audit-logs/).

Note

A transition plan from Audit Logs v1 to Audit Logs v2 will be communicated in due course.

## Key features

Audit Logs (version 2) provide a unified and standardized system for tracking and recording actions across Cloudflare products. This system enhances transparency and accountability by offering comprehensive insights into user-initiated and system-initiated activities within your Cloudflare environment.

* **Standardized logging**: Audit logs are automatically generated in a consistent format across all Cloudflare services, ensuring uniformity and eliminating inconsistencies.
* **Expanded product coverage**: Audit Logs covers 111 products, capturing actions from key endpoints, such as `/accounts`, `/zones`, `/user`, and `/memberships` APIs.
* **Granular filtering**: Uniformly formatted logs allow for precise filtering by actions, actors, methods, and resources, facilitating efficient investigations.
* **Enhanced context and transparency**: Each log entry includes detailed context, such as the authentication method used, the interface (API or dashboard) through which the action was performed, and mappings to Cloudflare Ray IDs for improved traceability.
* **Comprehensive activity capture**: Beyond create, edit, and delete actions, Audit Logs records GET requests and failed attempts, ensuring no critical activity is overlooked.

## Retention

* Audit logs are retained for 18 months before being deleted. No additional setup is required.

* In the Audit Logs v2 UI, queries are limited to the most recent 90 days for performance reasons. To access the full 18 months of data, use the API or [Logpush](https://developers.cloudflare.com/logs/logpush/).

* Enterprise customers can use [Logpush](https://developers.cloudflare.com/logs/logpush/) to store audit logs beyond 18 months. Logpush for Audit Logs v2 will be available for GA.

## Access Audit Logs

You can retrieve audit logs using either the API or the Cloudflare dashboard.

### API

Audit Logs are available through the Cloudflare API. To retrieve audit logs, use the following endpoint:

```bash
https://api.cloudflare.com/client/v4/accounts/{account_id}/logs/audit
```

Below is an example request to retrieve audit logs for a certain period of time along with its corresponding response. Replace the example values in the URL with your actual values:

* `account_id`: Your Cloudflare account identifier.
* `Since` (required): Start date for the audit log retrieval in the format yyyy-mm-dd.​
* `Before` (required) : End date for the audit log retrieval in the format yyyy-mm-dd.

```bash
GET https://api.cloudflare.com/client/v4/accounts/1234567890abcdef/logs/audit?since=2025-03-01T00:00:00Z&before=2025-03-26T23:59:59Z
```

```json
{
  "result": [
    {
      "action": "zone.settings.change",
      "actor": {
        "email": "user@example.com",
        "id": "0987654321abcdef"
      },
      "ip": "192.0.2.1",
      "method": "PUT",
      "interface": "dashboard",
      "resources": [
        {
          "resource_id": "zone123",
          "resource_type": "zone"
        }
      ],
      "timestamp": "2025-03-15T14:25:37Z"
    }
    // Additional log entries
  ],
  "success": true,
  "errors": [],
  "messages": []
}
```

For more information refer to the [API documentation](https://developers.cloudflare.com/api/resources/accounts/subresources/logs/subresources/audit/methods/list/#\(params\)%20default%20%3E%20\(param\)%20since%20%3E%20\(schema\)).

### Dashboard

To access audit logs in the Cloudflare dashboard:

In the Cloudflare dashboard, go to the **Audit Logs** page.

[Go to **Audit logs**](https://dash.cloudflare.com/?to=/:account/audit-log)

Note

The Audit Logs v2 is shown by default. You can switch between Audit Logs v2 and v1 as needed.

## Logpush job

Note

For customers who already have a Logpush job set up for Audit Logs v1, note that a separate Logpush job must be configured for [Audit Logs v2](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/audit_logs_v2/) (dataset). We will communicate the timeline for when Logpush Audit Logs v1 will be deprecated and turned off.

To create a Logpush job:

1. In the Cloudflare dashboard, go to the **Logpush** page.

   [Go to **Logpush**](https://dash.cloudflare.com/?to=/:account/logs)

2. Select **Create a Logpush job**.

3. In **Select a destination**, select the destination of your choice and add the destination details.

4. In the datasets section, select the [Audit Logs v2 dataset](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/audit_logs_v2/). Audit Logs v2 is an account-based dataset.

5. Once you are done configuring your logpush job, select **Submit**.

## Audit Log structure

Cloudflare's audit logs offer a detailed view of activity across your environment by capturing both the source of actions and the context in which they occur. These logs are categorized by who initiated the action (user or system) and whether the activity occurred within a specific account or spanned multiple accounts under the same user profile. This structure enables flexible filtering, investigation, and compliance monitoring.

### Initiation type

Audit logs can be initiated either by users or the system. Understanding the type of actor involved helps in identifying the source and intent of actions.

#### User initiated Audit Logs

Track actions performed directly by users through Cloudflare interfaces (dashboard or API). These logs capture who performed the action, when it occurred, and what resource was affected. User initiated actions can be performed by three actors:

* `actor_type="user"`: Action was performed by an individual user.
* `actor_type="Cloudflare_admin"`: Action was performed by Cloudflare.
* `actor_type="account"`: Action was performed using an account API token. Refer to the [Account API tokens](https://developers.cloudflare.com/fundamentals/api/get-started/account-owned-tokens/) documentation for more information.

#### System initiated Audit Logs

Record changes made automatically by Cloudflare systems, without direct user input. These logs provide visibility into internal processes, automated tasks, and security events. Some entries may include associated user context for traceability (`actor_type="system"`).

### Activity Scope

#### Account Activity Logs

Contain events scoped to a single Cloudflare account. These logs are filterable by `account ID` and reflect actions within that account only. You can optionally filter events further using the `resource_scope` field, which specifies whether the resource is associated with a user, an account, or a zone (`resource_scope ="user"`, `resource_scope ="accounts"`, or `resource_scope ="zones"`).

#### User Profile Activity Logs

Reflect actions associated with a user's login (email) across multiple accounts. These logs enable cross-account tracking and can be filtered by `user ID` or `email`. They are visible on any account the user had access to at the time of the activity. User Profile Activity Logs can be filtered using `resource_scope ="user"`.

The `GET /memberships` endpoint supports cross-account access. To query memberships, use the parameter `resource_scope=memberships`.

## Example how to query Audit Logs

Use the following example to get a list of audit logs for a user account.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Account Settings Write`
* `Account Settings Read`

```bash
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/logs/audit" \
  --request GET \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
```

```json
{
  "errors": [
    {
      "message": "message"
    }
  ],
  "result": [
    {
      "account": {
        "id": "4bb334f7c94c4a29a045f03944f072e5",
        "name": "Example Account"
      },
      "action": {
        "description": "Add Member",
        "result": "success",
        "time": "2024-04-26T17:31:07Z",
        "type": "create"
      },
      "actor": {
        "id": "f6b5de0326bb5182b8a4840ee01ec774",
        "context": "dash",
        "email": "alice@example.com",
        "ip_address": "198.41.129.166",
        "token_id": "token_id",
        "token_name": "token_name",
        "type": "user"
      },
      "raw": {
        "cf_ray_id": "8e9b1c60ef9e1c9a",
        "method": "POST",
        "status_code": 200,
        "uri": "/accounts/4bb334f7c94c4a29a045f03944f072e5/members",
        "user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) Safari/605.1.15"
      },
      "resource": {
        "id": "id",
        "product": "members",
        "request": {},
        "response": {},
        "scope": {},
        "type": "type"
      },
      "zone": {
        "id": "id",
        "name": "example.com"
      }
    }
  ],
  "result_info": {
    "count": "1",
    "cursor": "ASqdKd7dKgxh-aZ8bm0mZos1BtW4BdEqifCzNkEeGRzi_5SN_-362Y8sF-C1TRn60_6rd3z2dIajf9EAPyQ_NmIeAMkacmaJPXipqvP7PLU4t72wyqBeJfjmjdE="
  },
  "success": true
}
```

## Common terms and definitions

### Actor

The actor represents who performed the action. It includes identity attributes like user ID, email address, IP address, and the type of actor (`user`, `account`, `Cloudflare_admin`, or `system`). It also includes the context used to initiate the action, such as API or dashboard (`dash`).

### Action

The action field captures the nature of the event and whether it was successful. It includes a high-level type (e.g., `view`, `create`, `update`, `delete`), a specific description (such as `SSO_LOGIN`), the timestamp of when the action occurred, and the result (`success` or `failure`).

All `GET` requests are captured as `view` actions in Audit Logs.

### Account

This field refers to the Cloudflare account under which the action was executed. It includes a unique account ID and a human-readable account name to help associate activity with a customer environment.

### Resource

The resource identifies the object impacted by the action. It includes the resource type, the unique resource ID, the scope (`user`, `account`, or `zone`), and optionally the product associated with the change.

### Audit Log ID

This is a unique identifier for the log record itself. It can be used for deduplication, correlation, or referencing specific actions during investigations.
