---
title: Protect access to Microsoft 365 with dedicated egress IPs · Cloudflare
  Zero Trust docs
description: This tutorial covers how to secure access to your Microsoft 365
  applications with Cloudflare Gateway dedicated egress IPs.
lastUpdated: 2025-10-23T22:25:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/tutorials/m365-dedicated-egress-ips/
  md: https://developers.cloudflare.com/cloudflare-one/tutorials/m365-dedicated-egress-ips/index.md
---

Note

Only available on Zero Trust Enterprise plans.

This tutorial covers how to secure access to your Microsoft 365 applications with Cloudflare Gateway dedicated egress IPs.

You can map a named location in Microsoft Entra ID to a location associated with your dedicated egress IPs. Traffic will egress from Cloudflare with these IP addresses. If users attempt to access your Microsoft applications without these IPs, Entra ID will block access.

## Before you begin

Make sure you have:

* In Cloudflare, a Zero Trust Enterprise plan with [dedicated egress IPs](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/dedicated-egress-ips/)
* In Microsoft 365, an organization managed with [Microsoft Entra ID](https://learn.microsoft.com/en-us/entra/identity/)

## Create an egress policy in Cloudflare Gateway

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Gateway** > **Egress policies**.

2. Select **Add a policy**.

3. Name your policy, then add conditions to check users are configured in Microsoft Entra ID. For example, you can check for [identity conditions](https://developers.cloudflare.com/cloudflare-one/traffic-policies/identity-selectors/):

   | Selector | Operator | Value |
   | - | - | - |
   | User Group Names | in | `Sales and Marketing`, `Retail`, `U.S. Sales` |

   Additionally, you can check for [device posture conditions](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/):

   | Selector | Operator | Value | Logic |
   | - | - | - | - |
   | Passed Device Posture Check | is | `CrowdStrike Overall ZTA score (Crowdstrike s2s)` | And |
   | Passed Device Posture Check | is | `AppCheckMac - Required Software (Application)` | |

4. Enable **Use dedicated Cloudflare egress IPs**. Select your desired IPv4 and IPv6 addresses. For example:

   | Primary IPv4 address | IPv6 address |
   | - | - |
   | `203.0.113.0` | `2001:db8::/32` |

## Create a named IP range location in Microsoft Entra ID

1. Log in to the [Microsoft Azure portal](https://aka.ms/azureportal).
2. In the sidebar, select **Microsoft Entra ID**.
3. Go to **Security** > **Named locations**.
4. Select **IP ranges location**.
5. Name your location, then add the IP addresses used in your Cloudflare dedicated egress IP policy.
6. Select **Upload**.

This named location corresponds with the locations of your dedicated egress IPs.

## Create a conditional access policy in Microsoft Entra ID

1. In **Protect**, go to **Conditional Access**.
2. Select **Create new policy**.
3. Configure which Entra ID users you want to limit access for, and which traffic, applications, or actions you want to protect.
4. In **Conditions**, select **Locations**. Enable **Configure**.
5. In **Include**, select *Any location*. In **Exclude**, select the named location you created.
6. In **Access controls**, go to **Grant**. Enable *Block access*.

Your policy will block access for your selected users from any location except those using your dedicated egress IPs.

## Test your policies

1. Using [WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/), sign in to your Zero Trust organization with a user's account.
2. Go to any Microsoft 365 app within your organization. Entra ID should allow access.
3. Disconnect WARP from your Zero Trust organization. Entra ID should block access to any Microsoft 365 applications.
