---
title: Global policies · Cloudflare Zero Trust docs
description: Cloudflare Zero Trust applies a set of global policies to all accounts.
lastUpdated: 2025-10-23T19:01:53.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/global-policies/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/global-policies/index.md
---

Cloudflare Zero Trust applies a set of global policies to all accounts.

Zero Trust logs prepend an identifier to global policy names. For example, matches for the global policy **Allow Zero Trust Services** will appear in your logs with the name **Global Policy - Allow Zero Trust Services**.

The following policies are sorted by [order of precedence](https://developers.cloudflare.com/cloudflare-one/traffic-policies/order-of-enforcement/#order-of-precedence) within each policy type.

## DNS resolution policies

Gateway enforces global DNS and resolver policies before any other policies. This ensures the traffic is not blocked by user policies and gets resolved with Cloudflare's public DNS resolver, [1.1.1.1](https://developers.cloudflare.com/1.1.1.1/). Each global DNS policy evaluates traffic based on the domain in the query.

| Name | ID | Value | Action |
| - | - | - | - |
| Allow DNS queries for cloudflareclient.com domain | `00000001-e139-4a1b-90d5-698d8fa371e0` | `cloudflareclient.com` | allow |
| Resolve cloudflareclient.com through 1.1.1.1 | `00000001-e738-4554-823b-0b2c75af2c66` | `cloudflareclient.com` | resolve |
| Allow DNS queries for content.browser.run domain | `00000001-9bff-4d83-a9e4-e5ed321fe0b9` | `content.browser.run` | allow |
| Resolve content.browser.run through 1.1.1.1 | `00000001-0df5-472b-80c0-02888e7167ee` | `content.browser.run` | resolve |
| Allow DNS queries for edge.browser.run and cloudflarebrowser.com domains | `00000001-e2f1-4e99-bab3-91df88879587` | `edge.browser.run` and `cloudflarebrowser.com` | allow |
| Resolve edge.browser.run and cloudflarebrowser.com through 1.1.1.1 | `00000001-b103-44c6-a114-7a784cdf3fb7` | `edge.browser.run` and `cloudflarebrowser.com` | resolve |
| Allow DNS queries for help.teams.cloudflare.com and help.one.cloudflare.com domains | `00000001-b2fc-46db-b0f1-69ef3553bd7a` | `help.teams.cloudflare.com` and `help.one.cloudflare.com` | allow |
| Resolve help.teams.cloudflare.com and help.one.cloudflare.com through 1.1.1.1 | `00000001-ce13-486a-b006-ba0435ccb013` | `help.teams.cloudflare.com` and `help.one.cloudflare.com` | resolve |
| Allow DNS queries for cloudflare-gateway.com domain | `00000001-e83d-492b-995e-351970cd5e8e` | `cloudflare-gateway.com` | allow |
| Resolve cloudflare-gateway.com through 1.1.1.1 | `00000001-d9bc-4913-a2f5-905dbb3ecf9a` | `cloudflare-gateway.com` | resolve |
| Allow DNS queries for cloudflarestatus.com domain | `00000001-78da-4f8a-b9ee-76563f1ec46b` | `cloudflarestatus.com` | allow |
| Resolve cloudflarestatus.com through 1.1.1.1 | `00000001-4d1d-43a3-9015-c49fc3a6da31` | `cloudflarestatus.com` | resolve |
| Allow DNS queries for nel.cloudflare.com domain | `00000001-af28-4afa-8987-eadc21187e14` | `nel.cloudflare.com` | allow |
| Resolve nel.cloudflare.com through 1.1.1.1 | `00000001-0034-45a0-8333-f339451fba46` | `nel.cloudflare.com` | resolve |
| Allow DNS queries for api.cloudflare.com domain | `00000001-5eea-4932-8dd5-8e1ec9770396` | `api.cloudflare.com` | allow |
| Resolve api.cloudflare.com through 1.1.1.1 | `00000001-4f0c-4f86-9b96-5d26123a194b` | `api.cloudflare.com` | resolve |
| Allow DNS queries for dash.teams.cloudflare.com domain | `00000001-0f75-48a9-b3e1-925a974d2b65` | `dash.teams.cloudflare.com` | allow |
| Resolve dash.teams.cloudflare.com through 1.1.1.1 | `00000001-3d84-41a6-bc84-3014685c0d81` | `dash.teams.cloudflare.com` | resolve |
| Allow DNS queries for one.dash.cloudflare.com domain | `00000001-a9fd-40de-a662-51d3a3ae0ad8` | `one.dash.cloudflare.com` and `one.dash.fed.cloudflare.com` | allow |
| Resolve one.dash.cloudflare.com through 1.1.1.1 | `00000001-70f2-4eea-b711-201bca434ed4` | `one.dash.cloudflare.com` and `one.dash.fed.cloudflare.com` | resolve |
| Allow DNS queries for dash.cloudflare.com domain | `00000001-0c2a-4b31-8606-3e5a1d87c1bf` | `dash.cloudflare.com` and `dash.fed.cloudflare.com` | allow |
| Resolve dash.cloudflare.com through 1.1.1.1 | `00000001-c47f-41f3-b234-d66c82b8d422` | `dash.cloudflare.com` and `dash.fed.cloudflare.com` | resolve |
| Allow DNS queries for cloudflareportal.com, cloudflareok.com and cloudflarecp.com domains | `00000001-1c6c-4793-b48f-799eee6e0e31` | `cloudflareportal.com`, `cloudflareok.com`, and `cloudflarecp.com` | allow |
| Resolve cloudflareportal.com, cloudflareok.com and cloudflarecp.com through 1.1.1.1 | `00000001-8c35-4d7d-9dbb-cb7350375b7b` | `cloudflareportal.com`, `cloudflareok.com`, and `cloudflarecp.com` | resolve |
| Allow DNS queries for cloudflareaccess.com domain | `00000001-d738-4dad-bac4-1a50201d9503` | `cloudflareaccess.com` | allow |
| Resolve cloudflareaccess.com through 1.1.1.1 | `00000001-4404-4572-80f6-f7b098909460` | `cloudflareaccess.com` | resolve |
| Allow DNS queries for blocked.teams.cloudflare.com domain | `00000001-76f4-4438-b8ab-a9da53f4a2f1` | `blocked.teams.cloudflare.com` and `blocked.teams.fed.cloudflare.com` | allow |
| Resolve blocked.teams.cloudflare.com through 1.1.1.1 | `00000001-af3c-458f-aeb2-b3bb5d3fe1d5` | `blocked.teams.cloudflare.com` and `blocked.teams.fed.cloudflare.com` | resolve |
| Allow DNS queries for developers.cloudflare.com domain | `00000001-4263-4808-8457-4d4329c91f66` | `developers.cloudflare.com` | allow |
| Resolve developers.cloudflare.com through 1.1.1.1 | `00000001-9f91-4462-9270-78beca5b4dbc` | `developers.cloudflare.com` | resolve |
| Allow DNS queries for speed.cloudflare.com domain | `00000001-4fc0-4286-b783-6c442adda171` | `speed.cloudflare.com` | allow |
| Resolve speed.cloudflare.com through 1.1.1.1 | `00000001-ec51-4471-9e78-bd47d46a3002` | `speed.cloudflare.com` | resolve |
| Allow DNS requests to browser-rendered Access Apps | `00000001-1232-4a9f-a165-1e8ed59483c4` | `*.zero-trust-apps.cfdata.org`, `*.zero-trust-apps-staging.cfdata.org`, `*.zero-trust-apps.fed.cfdata.org`, or `*.zero-trust-apps-staging.fed.cfdata.org` | allow |
| Resolve browser-rendered Access Apps domains through 1.1.1.1 | `00000001-9461-43c7-ba63-d0fdf9376bd4` | `*.zero-trust-apps.cfdata.org`, `*.zero-trust-apps-staging.cfdata.org`, `*.zero-trust-apps.fed.cfdata.org`, or `*.zero-trust-apps-staging.fed.cfdata.org` | resolve |

## Network proxy policies

| Name | ID | Criteria | Value | Action | Description |
| - | - | - | - | - | - |
| Allow CF Network Error Logging L4 | `00000001-e4af-4b82-8f8c-c79c1d5d212e` | Hostname | `*.nel.cloudflare.com` | allow | Allows SNI domains for WARP registration. |
| Allow CF Client | `00000001-8c3d-4e27-a01b-af8418000077` | Hostname | `*.cloudflareclient.com` and `*.fed.cloudflareclient.com` | allow | Allows Zero Trust client. |
| Allow Gateway Proxy PAC | `00000001-776e-438d-9856-987d7053762b` | Hostname | `*.cloudflare-gateway.com` and `*.fed.cloudflare-gateway.com` | allow | Allows Gateway proxy with [PAC files](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/pac-files/). |
| Allow Zero Trust Services | `00000001-e1e8-421b-a0fe-895397489f28` | Hostname | `dash.teams.cloudflare.com`, `help.teams.cloudflare.com`, `blocked.teams.cloudflare.com`, `blocked.teams.fed.cloudflare.com`, `api.cloudflare.com`, `api.fed.cloudflare.com`, `cloudflarestatus.com`, `www.cloudflarestatus.com`, `one.dash.cloudflare.com`, `one.dash.fed.cloudflare.com`, `help.one.cloudflare.com`, `dash.cloudflare.com`, `dash.fed.cloudflare.com`, and `developers.cloudflare.com` | allow | Allows Cloudflare Zero Trust services. |
| Allow Access Apps L4 | `00000001-daa2-41e2-8a88-698af4066951` | Hostname | `*.cloudflareaccess.com` and `*.fed.cloudflareaccess.com` | allow | Allows [Cloudflare Access](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) applications. |
| Allow HTTP requests to browser-rendered Access Apps | `00000001-1f93-4476-8f92-9aa4407d1c5f` | Hostname | `*.zero-trust-apps.cfdata.org`, `*.zero-trust-apps-staging.cfdata.org`, `*.zero-trust-apps.fed.cfdata.org`, or `*.zero-trust-apps-staging.fed.cfdata.org` | allow | Allows Cloudflare Access terminal applications [rendered in a browser](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/browser-rendering/#ssh-and-vnc). |

## HTTP inspection policies

| Name | ID | Criteria | Value | Action | Description |
| - | - | - | - | - | - |
| Prevent Account Change Block | `00000001-d1f2-461a-8253-501c8d882a15` | Hostname | `*.cloudflareclient.com` and `*.fed.cloudflareclient.com`; not `notifications.cloudflareclient.com` or `notifications.fed.cloudflareclient.com` | bypass | Ensures users cannot accidentally block themselves from making account changes. |
| Bypass RBI Assets | `00000001-df61-4068-aa6c-0f684c3cd4e6` | Hostname | `*.content.browser.run` | bypass | Required for [Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/). |
| Inspect RBI Urls | `00000001-3faa-4f59-98d4-0f6d6af4b6d0` | Hostname | `*.edge.browser.run` and `*.cloudflarebrowser.com` | bypass | Required for Browser Isolation. |
| Allow Gateway Help Page | `00000001-8e9a-4429-b3c2-d267d0ce6114` | Hostname | `help.teams.cloudflare.com` and `help.one.cloudflare.com` | allow | Used by the WARP client to check if Gateway is on by inspecting the certificate and checking if it is properly installed on the client device. |
| Bypass Gateway DNS | `00000001-d9c0-46b0-8704-2ea5b9d7bdfc` | Hostname | `*.cloudflare-gateway.com` and `*.fed.cloudflare-gateway.com` | bypass | Ensures requests to the `cloudflare-gateway.com` DNS endpoint will not be inspected. |
| Bypass CF Status | `00000001-5399-4b71-a9fc-d4d90ccf0758` | Hostname | `*.cloudflarestatus.com` | bypass | Bypasses `cloudflarestatus.com` so users can reach the status page in case of a Gateway outage. |
| Bypass CF Network Error Logging | `00000001-dfe0-4737-8d1e-8191e8f637df` | Hostname | `*.nel.cloudflare.com` | bypass | Bypasses `*.nel.cloudflarestatus.com` for Cloudflare's network error logging feature. |
| Bypass CF API | `00000001-a424-43fb-b1f1-d3eb35ed7ddd` | Hostname | `api.cloudflare.com` and `api.fed.cloudflare.com` | bypass | Bypasses Cloudflare's API endpoint. |
| Prevent ZT Dashboard Lockout | `00000001-d38e-42db-96fe-60613b6b308f` | Hostname | `dash.teams.cloudflare.com`, `one.dash.cloudflare.com`, and `one.dash.fed.cloudflare.com` | bypass | Prevents users from being locked out of the Zero Trust dashboard. |
| Bypass CF Dashboard | `00000001-d343-4ded-908e-b3fe43c5e61e` | Hostname | `*.dash.cloudflare.com` and `*.dash.fed.cloudflare.com` | bypass | Bypasses the Cloudflare dashboard and subdomains. |
| Bypass Zero Trust Captive Portal Sites | `00000001-8b62-4367-919e-5c160a06ddf7` | Hostname | `cloudflareportal.com`, `cloudflareok.com`, and `cloudflarecp.com` | bypass | Bypasses the Zero Trust captive portal detection sites. |
| Bypass OCSP | `00000001-34ce-47c7-ad0f-199f46eba194` | Application | Online Certificate Status Protocol | bypass | Enables OCSP stapling. |
| Allow Access Apps L7 | `00000001-8d6b-4951-8a18-3bbc9010976c` | Hostname | `*.cloudflareaccess.com` and `*.fed.cloudflareaccess.com` | allow | Allows Cloudflare Access applications. |
| Prevent Block Page Loop | `00000001-48b1-4ade-93c1-f0f3759dc19c` | Hostname | `blocked.teams.cloudflare.com` and `blocked.teams.fed.cloudflare.com` | bypass | Prevents an infinite loop on the Gateway block page. |
| Always Blocked Categories | `00000001-bed5-462e-b0f1-2e2c3555e9f7` | Content Category | [Child Abuse category](https://developers.cloudflare.com/cloudflare-one/traffic-policies/domain-categories/#category-and-subcategory-ids) | block | Blocks child abuse materials (CSAM). |
| Don't Isolate RBI Help Pages | `00000001-1a18-431f-9c9d-bce431f1002a` | Hostname | `developers.cloudflare.com` and `help.cloudflarebrowser.com` | noisolate | Prevents browser isolation of Cloudflare developer docs and help pages to help users troubleshoot configuration issues. |
| Don't AV Scan CF Speed | `00000001-c194-408f-87dd-9a366ce76e12` | Hostname | `speed.cloudflare.com` | noscan | Allows files transferred by the Cloudflare speed test. |
