---
title: Use WARP as an on-ramp · Cloudflare Zero Trust docs
description: Use WARP as an on-ramp to WAN Tunnels and route traffic from user
  devices with WARP installed to any network connected with Cloudflare Tunnel or
  IP-layer tunnels (anycast GRE, IPsec, or CNI).
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/zero-trust/warp/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/zero-trust/warp/index.md
---

Note

By default, direct WARP-to-WARP connections are not supported for devices located behind WAN Tunnels with WARP enabled. This is due to issues caused by double encapsulation and asymmetric routing.

When a device is behind WAN Tunnels, it is recommended to avoid enabling WARP. Instead, access the device using its local LAN IP from remote systems, rather than relying on WARP-to-WARP communication.

If you do want to use WARP on a device behind WAN Tunnels and connect to its WARP IP (within the `100.96.0.0/12` range), you will need to adjust your WARP profiles. Specifically, exclude the `100.96.0.0/12` subnet from the on-premises WARP profile, and include it in the off-premises profile.

Use [WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/) as an on-ramp to WAN Tunnels and route traffic from user devices with WARP installed to any network connected with Cloudflare Tunnel or Magic IP-layer tunnels (anycast [GRE, IPsec](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/#add-tunnels), or [CNI](https://developers.cloudflare.com/network-interconnect/)). Take advantage of the integration between WAN Tunnels and [Magic Firewall](https://developers.cloudflare.com/magic-firewall/) and enforce policies at Cloudflare's global network.

## Prerequisites

Before you can begin using WARP as an on-ramp to WAN Tunnels, you must set up your [Zero Trust account](https://developers.cloudflare.com/cloudflare-one/setup/#create-a-zero-trust-organization).

## IP ranges

When connecting a WARP device to WAN Tunnels, you will have virtual IP addresses from WARP, in the `100.96.0.0/12` range.

***

## Set up WARP with WAN Tunnels

### 1. Route packets back to WARP devices

Route packets back to WARP devices from services behind an anycast GRE or other type tunnel. You need to do this before actually installing WARP. Otherwise, your infrastructure will not route packets correctly to Cloudflare global network and connectivity will fail.

Cloudflare will assign IP addresses from the WARP virtual IP (VIP) space to your WARP devices. To view your virtual IP address, go to [Cloudflare One](https://one.dash.cloudflare.com/), and select **My Team > Devices**.

All packets with a destination IP in the VIP space need to be routed back through the tunnel. For example, with a single GRE tunnel named `gre1`, in Linux, the following command would add a routing rule that would route such packets:

```sh
ip route add 100.96.0.0/12 dev gre1
```

Note

After set up, **HTTP** and **Network logs** in Gateway will show the virtual IP address of your WARP device as the **Source IP**. DNS logs will continue to show the original WARP device IP because DNS traffic is sent over the public Internet to Cloudflare's public-facing resolver.

### 2. Configure Split Tunnels

Configure [Split Tunnels](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/) from your Zero Trust account to only include traffic from the private IP addresses you want to access.

Optionally, you can configure Split Tunnels to include IP ranges or domains you want to use for connecting to public IP addresses.

### 3. Install the WARP client on your device

Refer to [Deploy WARP to your organization](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) for more information on whether to choose a manual or managed deployment.

You should be able to access Private IP addresses specified in the Split Tunnel configuration.

You must log out and log back in with at least one WARP device to ensure the configuration updates on your device.

Run `traceroute`

WAN Tunnels clients connecting through [GRE](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/#add-tunnels), [IPsec](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/#add-tunnels), [CNI](https://developers.cloudflare.com/network-interconnect/) or [WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/) that want to perform a `traceroute` to an endpoint behind a [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) will need to change some settings to make the command useful. Refer to [Run `traceroute`](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/traceroute/) for more information.

## Double encapsulation

When a WARP user goes to a location (like an office) with a WAN Tunnels tunnel already set up, WARP traffic is doubly encapsulated - first by WARP and then by WAN Tunnels. This is unnecessary, since each on-ramp method provides full Zero Trust protection.

Since WARP traffic is already protected on its own, Cloudflare recommends that you set up WAN Tunnels to exclude WARP traffic, sending it to the Internet through regular connections.

To learn which IP addresses and UDP ports you should exclude to accomplish this, refer to [WARP ingress IP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#warp-ingress-ip).

### WARP and Appliances

If you have Appliances and WARP clients deployed in your premises, Appliances automatically routes WARP traffic to the Internet rather than WAN Tunnels IPsec tunnels. This prevents traffic from being encapsulated twice.

You may need to configure your firewall to allow this new traffic. Make sure to allow the following IPs and ports:

* **Destination IPs**: `162.159.193.0/24`, `162.159.197.0/24`
* **Destination ports**: `443`, `500`, `1701`, `2408`, `4443`, `4500`, `8095`, `844`

Refer to [WARP with firewall](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/) for more information on this topic.

## Test WARP integration

Before testing, be sure to [configure domain fallback](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/#add-a-domain) for the server or service in WARP settings. This is needed because by default Cloudflare Zero Trust excludes common top level domains used for local resolution from being sent to Gateway for processing.

If WARP integration has been enabled for the account within the last day, log off and on again in the WARP client before testing.

To check if WARP is working correctly as an on-ramp, you can do a resolution test on a [fully qualified domain name (FQDN)](https://en.wikipedia.org/wiki/Fully_qualified_domain_name) for a server or service in the WAN Tunnels. Test this from a user with a WARP device.

For example:

```sh
nslookup <SERVER_BEHIND_MAGIC_WAN>
```

This DNS lookup should return a valid IP address associated with the server or service you are testing for.

Next, test with a browser that you can connect to a service on the WAN by opening a webpage that is only accessible on the WAN. The server can be the same server used in the DNS lookup or another server in the WAN. Connecting using an IP address instead of a domain name should work.
