---
title: Changelog · Cloudflare Zero Trust docs
description: Review recent changes to WAN Tunnels.
lastUpdated: 2025-10-27T11:06:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/changelog/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/changelog/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/magic-wan.xml)

## 2025-09-11

**DNS filtering for private network onramps**

[Magic WAN](https://developers.cloudflare.com/magic-wan/zero-trust/cloudflare-gateway/#dns-filtering) and [WARP Connector](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/site-to-internet/#configure-dns-resolver-on-devices) users can now securely route their DNS traffic to the Gateway resolver without exposing traffic to the public Internet.

Routing DNS traffic to the Gateway resolver allows DNS resolution and filtering for traffic coming from private networks while preserving source internal IP visibility. This ensures Magic WAN users have full integration with our Cloudflare One features, including [Internal DNS](https://developers.cloudflare.com/cloudflare-one/traffic-policies/resolver-policies/#internal-dns) and [hostname-based policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/#selector-prerequisites).

To configure DNS filtering, change your Magic WAN or WARP Connector DNS settings to use Cloudflare's shared resolver IPs, `172.64.36.1` and `172.64.36.2`. Once you configure DNS resolution and filtering, you can use *Source Internal IP* as a traffic selector in your [resolver policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/resolver-policies/) for routing private DNS traffic to your [Internal DNS](https://developers.cloudflare.com/dns/internal-dns/).

## 2025-09-08

**Custom IKE ID for IPsec Tunnels**

Now, Magic WAN customers can configure a custom IKE ID for their IPsec tunnels. Customers that are using Magic WAN and a VeloCloud SD-WAN device together can utilize this new feature to create a high availability configuration.

This feature is available via API only. Customers can read the Magic WAN documentation to learn more about the [Custom IKE ID feature and the API call to configure it](https://developers.cloudflare.com/magic-wan/configuration/common-settings/custom-ike-id-ipsec/).

## 2025-09-05

**Bidirectional tunnel health checks are compatible with all Magic on-ramps**

All bidirectional tunnel health check return packets are accepted by any Magic on-ramp.

Previously, when a Magic tunnel had a bidirectional health check configured, the bidirectional health check would pass when the return packets came back to Cloudflare over the same tunnel that was traversed by the forward packets.

There are SD-WAN devices, like VeloCloud, that do not offer controls to steer traffic over one tunnel versus another in a high availability tunnel configuration.

Now, when a Magic tunnel has a bidirectional health check configured, the bidirectional health check will pass when the return packet traverses over any tunnel in a high availability configuration.

## 2025-07-30

**Magic Transit and Magic WAN health check data is fully compatible with the CMB EU setting.**

Today, we are excited to announce that all Magic Transit and Magic WAN customers with CMB EU ([Customer Metadata Boundary - Europe](https://developers.cloudflare.com/data-localization/metadata-boundary/)) enabled in their account will be able to access GRE, IPsec, and CNI health check and traffic volume data in the Cloudflare dashboard and via API.

This ensures that all Magic Transit and Magic WAN customers with CMB EU enabled will be able to access all Magic Transit and Magic WAN features.

Specifically, these two GraphQL endpoints are now compatible with CMB EU:

* `magicTransitTunnelHealthChecksAdaptiveGroups`
* `magicTransitTunnelTrafficAdaptiveGroups`

## 2025-02-14

**Configure your Magic WAN Connector to connect via static IP assigment**

You can now locally configure your [Magic WAN Connector](https://developers.cloudflare.com/magic-wan/configuration/connector/) to work in a static IP configuration.

This local method does not require having access to a DHCP Internet connection. However, it does require being comfortable with using tools to access the serial port on Magic WAN Connector as well as using a serial terminal client to access the Connector's environment.

For more details, refer to [WAN with a static IP address](https://developers.cloudflare.com/magic-wan/configuration/connector/configure-hardware-connector/#bootstrap-via-serial-console).

## 2024-12-17

**Establish BGP peering over Direct CNI circuits**

Magic WAN and Magic Transit customers can use the Cloudflare dashboard to configure and manage BGP peering between their networks and their Magic routing table when using a Direct CNI on-ramp.

Using BGP peering with a CNI allows customers to:

* Automate the process of adding or removing networks and subnets.
* Take advantage of failure detection and session recovery features.

With this functionality, customers can:

* Establish an eBGP session between their devices and the Magic WAN / Magic Transit service when connected via CNI.
* Secure the session by MD5 authentication to prevent misconfigurations.
* Exchange routes dynamically between their devices and their Magic routing table.

Refer to [Magic WAN BGP peering](https://developers.cloudflare.com/magic-wan/configuration/manually/how-to/configure-routes/#configure-bgp-routes) or [Magic Transit BGP peering](https://developers.cloudflare.com/magic-transit/how-to/configure-routes/#configure-bgp-routes) to learn more about this feature and how to set it up.

## 2025-02-14

**Sites feature available to all WAN Tunnels customers**

All WAN Tunnels customers now have full access to the WAN Tunnels sites feature. Customers can configure a WAN Tunnels site either with or without an Appliance.

## 2024-12-17

**Appliances configurable health checks**

Health check rate on Appliances IPsec tunnels are now configurable.

## 2024-12-17

**BGP support for Cloudflare Network Interconnect (CNI)**

WAN Tunnels customers can now establish BGP peering over Direct CNI circuits. Customers can now dynamically exchange routes and path availability status between their router device and the WAN Tunnels table.

## 2024-12-12

**LAN Policy improvements for the Appliances**

Appliances LAN Policy now supports unidirectional traffic flows and port-ranges.

## 2024-10-01

**Early access testing for BGP on CNI 2.0 circuits**

Customers can exchange routes dynamically with their Magic virtual network overlay via Direct CNI or Cloud CNI based connectivity.

## 2024-09-27

**Appliances sends WARP client traffic to Internet**

All Appliances now route WARP client traffic directly to the Internet, bypassing IPsec tunneling, to prevent double encapsulation of WARP traffic.

## 2024-07-17

**Updates to High Availability on the Appliances**

The High Availability feature on Appliances now supports additional failover conditions, DHCP lease syncing, and staggered upgrades.

## 2024-06-23

**ICMP support for traffic sourced from private IPs**

WAN Tunnels will now support ICMP traffic sourced from private IPs going to the Internet via Gateway.

## 2024-06-05

**Application based prioritization**

The Appliances can now prioritize traffic on a per-application basis.

## 2024-05-31

**WARP virtual IP addresses**

Customers using Gateway to filter traffic to WAN Tunnels destinations will now see traffic from Cloudflare egressing with WARP virtual IP addresses (CGNAT range), rather than public Cloudflare IP addresses. This simplifies configuration and improves visibility for customers.

## 2024-01-23

**Network segmentation**

You can define policies in your Appliance to either allow traffic to flow between your LANs without it leaving your local premises or to forward it via the Cloudflare network where you can add additional security features.
