---
title: API deployment · Cloudflare Zero Trust docs
description: When you choose an API deployment, email messages only reach Email
  security after they have already reached a user's inbox.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/api/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/api/index.md
---

When you choose an API deployment, email messages only reach Email security after they have already reached a user's inbox.

Then, through an integration with your email provider, Email security can [auto-move messages](https://developers.cloudflare.com/cloudflare-one/email-security/settings/auto-moves/) based on your organization's policies.

![With API deployment, messages travel through Email security's email filter after reaching your users.](https://developers.cloudflare.com/_astro/M365_API_Deployment_Graph.CpU5R2vm_1KHeBu.webp)

## Benefits

When you choose API deployment, you get the following benefits:

* Easy protection for complex email architectures, without requiring any change to mailflow operations.
* Agentless deployment for Microsoft 365.

## Limitations

However, API deployment also has the following disadvantages:

* Email security is dependent on Microsoft's Graph API, and outages will increase the message dwell time in the inbox.
* Your email provider may throttle API requests from Email security.
* Email security requires read and write access to mailboxes.
* Requires API support from your email provider (does not typically support on-premise providers).
* Detection rates may be lower if multiple solutions exist.
* Messages cannot be modified or quarantined.
