---
title: User submissions · Cloudflare Zero Trust docs
description: User submissions are the emails your users submitted for
  reclassification. User submissions help enhance our detection model, but can
  be escalated for human review.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/user-submissions/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/user-submissions/index.md
---

User submissions are the emails your users submitted for reclassification. User submissions help enhance our detection model, but can be escalated for human review.

Any email that is reported as [phish](https://developers.cloudflare.com/cloudflare-one/email-security/settings/phish-submissions/#reclassify-an-email) will be displayed under **User submissions**.

Note

[PhishGuard](https://developers.cloudflare.com/cloudflare-one/email-security/phishguard/) customers can have submissions analyzed when submitting at either user or team level. Any non-PhishGuard customer can still have submissions analyzed by submitting at team level.

## View user submissions

To view user submissions:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/).
2. Select **Email security** > **Reclassifications**.
3. Select **User submissions**.

## Filter user submissions

Select among the following filters:

* **Date Range**: Select a date range from the last 7, last 30, and last 90 days.
* **Original disposition**: Select among the [available values](https://developers.cloudflare.com/cloudflare-one/email-security/reference/dispositions-and-attributes/#available-values).
* **Submitted as**: Select among the [available values](https://developers.cloudflare.com/cloudflare-one/email-security/reference/dispositions-and-attributes/#available-values).

Once you have selected all the filters, select **Apply filters**.

The dashboard will populate the table with the list of emails your users submitted for reclassification, including a **Submission ID**, and the **Email subject**.

## View submission details

To gain more details on a specific reclassification:

1. Go to the reclassification you want to have more details for.
2. Select the three dots > select among **View more**, **View email message**, **View similar details**, and **Escalate**.

## Escalate a reclassification

To escalate a reclassification:

1. Go to the reclassification you want to escalate.
2. Select the three dots > select **Escalate**.
3. The dashboard will display a message to authorize escalation. Select **Escalate**.
