---
title: Data loss prevention · Cloudflare Zero Trust docs
description: Cloudflare Data Loss Prevention (DLP) allows you to scan your web
  traffic and SaaS applications for the presence of sensitive data such as
  social security numbers, financial information, secret keys, and source code.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/
  md: https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/index.md
---

Availability

Available as an add-on to Zero Trust Enterprise plans.

Users on Zero Trust Free and Pay-as-you-go plans can use the [Financial Information](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/predefined-profiles/#financial-information) and [Social Security, Insurance, Tax, and Identifier Numbers](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-profiles/predefined-profiles/#social-security-insurance-tax-and-identifier-numbers) predefined profiles, [payload logging](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#log-the-payload-of-matched-rules), and [false positive reporting](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/#report-false-positives).

Cloudflare [Data Loss Prevention](https://www.cloudflare.com/learning/access-management/what-is-dlp/) (DLP) allows you to scan your web traffic and SaaS applications for the presence of sensitive data such as social security numbers, financial information, secret keys, and source code.

To prevent interference, Cloudflare does not write scanned content to disk. Instead, DLP only encrypts and temporarily stores content in memory. Optionally, you can configure [payload logging](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#log-the-payload-of-matched-rules) to store encrypted copies of payloads from matching HTTP requests or a [Logpush destination](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/logging-options/#send-http-requests-to-logpush-destination) to export entire matching HTTP requests.

## Data in transit

Data Loss Prevention complements [Secure Web Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/) to detect sensitive data transferred in HTTP requests. DLP scans the entire HTTP body, which may include uploaded or downloaded files, chat messages, forms, and other web content. You can also use DLP with [Email security](https://developers.cloudflare.com/cloudflare-one/email-security/) to scan [outbound emails](https://developers.cloudflare.com/cloudflare-one/email-security/outbound-dlp/).

DLP requires [Gateway HTTP filtering](https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/http/) with [TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/) for visibility into data in transit. The depth of visibility varies for each site or application. DLP does not scan any traffic that bypasses Cloudflare Gateway (such as traffic that matches a [Do Not Inspect](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#do-not-inspect) policy).

To get started, refer to [Scan HTTP traffic with DLP](https://developers.cloudflare.com/cloudflare-one/data-loss-prevention/dlp-policies/).

## Data at rest

Data Loss Prevention complements [Cloudflare CASB](https://developers.cloudflare.com/cloudflare-one/integrations/cloud-and-saas/) to detect sensitive data stored in your SaaS applications. Unlike data in transit scans which read files sent through Cloudflare Gateway, CASB retrieves files directly via the API. Therefore, Gateway and WARP settings (such as [Do Not Inspect](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/#do-not-inspect) policies and [Split Tunnel](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/) configurations) will not affect data at rest scans.

To get started, refer to [Scan SaaS applications with DLP](https://developers.cloudflare.com/cloudflare-one/cloud-and-saas-findings/casb-dlp/).

## Supported file types

### Formats

DLP supports reporting and scanning the following file types:

* Text and CSV
* Microsoft Office 2007 and later (`.docx`, `.xlsx,` `.pptx`), including Microsoft 365
* PDF
* ZIP files containing the above

DLP will scan the text contained in text, Microsoft Office, and PDF files.

### Size

DLP can scan files less than or equal to 100 MB in size. ZIP files can be recursively compressed a maximum of 10 times, and each content file within the ZIP file must be less than or equal to 200 MB in uncompressed size.
