---
title: Zoom · Cloudflare Zero Trust docs
description: This guide covers how to configure Zoom as a SAML application in
  Cloudflare One.
lastUpdated: 2025-10-27T15:01:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/zoom-saas/
  md: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/zoom-saas/index.md
---

This guide covers how to configure [Zoom](https://support.zoom.com/hc/en/article?id=zm_kb\&sysparm_article=KB0060673) as a SAML application in Cloudflare One.

## Prerequisites

* An [identity provider](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/) configured in Cloudflare One
* Admin access to a Zoom Business, Education, or Enterprise account
* An [associated domain](https://support.zoom.com/hc/en/article?id=zm_kb\&sysparm_article=KB0066259) configured in your Zoom account
* A [vanity URL](https://support.zoom.com/hc/en/article?id=zm_kb\&sysparm_article=KB0061540) configured in your Zoom account

## 1. Add a SaaS application to Cloudflare One

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Access controls** > **Applications**.

2. Select **Add an application** > **SaaS** > **Select**.

3. For **Application**, select *Zoom*.

4. For the authentication protocol, select **SAML**.

5. Select **Add application**.

6. Fill in the following fields:

   * **Entity ID**: `https://<your-vanity-url>.zoom.us`
   * **Assertion Consumer Service URL**: `https://<your-vanity-url>.zoom.us/saml/SSO`
   * **Name ID format**: *Email*

7. Copy the **Access Entity ID or Issuer**, **Public key**, and **SSO endpoint**.

8. Configure [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) for the application.

9. Save the application.

## 2. Add a SAML SSO provider in Zoom

1. In Zoom, go to **Advanced** > **Single Sign-On**.

2. For **Vanity URL**, select the vanity URL you want to configure SSO for.

3. Fill out the following fields:

   * **Sign in page URL**: SSO endpoint from application configuration in Cloudflare One
   * **Identity Provider Certificate**: Public key from application configuration in Cloudflare One
   * **Service Provider (SP) Entity ID**: `yourvanityurl.zoom.us` (no `https://`)
   * **Issuer (DP Entity ID)**: Access Entity ID or Issuer from application configuration in Cloudflare One

4. For **Binding**, select *http-redirect*.

5. For **Signature Hash Algorithm**, ensure **SHA-256** is selected.

6. Under **Security**, turn off **Sign SAML request** and **Sign SAML logout request**.

7. Select **Save Changes**.

8. Go to **Advanced** > **Security**.

9. Under **Sign-in Methods**, ensure **Allow users to sign in with Single Sign-On (SSO)** is turned on.

## 3. Test the integration

Open an incognito browser window, go to your Zoom vanity URL, and select **Sign in**. You will be redirected to the Cloudflare Access login screen and prompted to sign in with your identity provider.

Once this is successful, you can require SSO for users in your associated domain(s) by completing the following steps:

1. In Zoom, go to **Advanced** > **Security**.
2. Under **Sign-in Methods**, turn on **Require users to sign in with SSO if their e-mail address belongs to one of the domains below**.
3. Under **Select Domains**, turn on the domains that you want to require SSO for.
4. (Optional) Under **Specify users who can bypass SSO sign-in**, add your desired users.
5. Select **Save**.
