---
title: Jamf Pro · Cloudflare Zero Trust docs
description: This guide covers how to configure Jamf Pro as a SAML application
  in Cloudflare One.
lastUpdated: 2025-10-27T15:01:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/jamf-pro-saas/
  md: https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/saas-apps/jamf-pro-saas/index.md
---

This guide covers how to configure [Jamf Pro](https://learn.jamf.com/en-US/bundle/jamf-pro-documentation-current/page/Single_Sign-On.html) as a SAML application in Cloudflare One.

## Prerequisites

* An [identity provider](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/) configured in Cloudflare One
* Admin access to a Jamf Pro account

## 1. Collect Jamf Pro information

1. In Jamf Pro, go to **Settings** > **Systems** > **Single Sign-On** > **Edit**.
2. Copy the pre-populated URL in **Entity ID**.
3. Paste the URL in a web browser to download the Jamf metadata file.
4. Open the `metadata.xml` file in a text editor, and copy the values for **Entity ID** and **Assertion Consumer Service**.

## 2. Add a SaaS application to Cloudflare One

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Access controls** > **Applications**.

2. Select **Add an application** > **SaaS**.

3. For **Application**, enter `Jamf` or `Jamf Pro` and select the corresponding textbox that appears.

4. For the authentication protocol, select **SAML**.

5. Select **Add application**.

6. Fill in the following fields:

   * **Entity ID**: Entity ID value from Jamf Pro metadata file.
   * **Assertion Consumer Service URL**: Assertion Consumer Service value from Jamf Pro metadata file.
   * **Name ID format**: *Email*

7. Copy the **SAML Metadata endpoint**.

8. Configure [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) for the application.

9. Save the application.

## 3. Edit Access SAML Metadata

1. Paste the **SAML Metadata endpoint** from application configuration in Cloudflare One into a browser.
2. Copy the file and paste it into a text editor.
3. Change `WantAuthnRequestsSigned="true"` to `WantAuthnRequestsSigned="false"`.
4. Set the file extension as `.xml` and save.

## 4. Add a SAML SSO provider to Jamf Pro

1. In Jamf Pro, go to **Settings** > **Single Sign-On** > **Edit**.

2. In Identity Provider menu, select **Other**.

3. Label **Other provider** as `Cloudflare`.

4. Fill in the following fields:

   * **Entity ID**: Entity ID from Jamf Pro metadata file.
   * **Identity Provider Metadata Source**: Select **Metadata File** and upload the `.xml` file from step [2. Edit Access SAML Metadata](#2-add-a-saas-application-to-cloudflare-one).
   * **Identity Provider User Mapping**: *Name ID*
   * **Jamf Pro User Mapping**: *Email*

5. Turn on **Single Sign On**.

Note

The Failover Login URL located on this page can be used to log in if your SSO does not work.

## 5. Test the Integration

Log out of Jamf Pro and open an incognito browser window. Go to your Jamf Pro URL. You will be redirected to the Cloudflare Access login screen and prompted to sign in with your identity provider.
