---
title: Introducing Origin Restrictions for Media Transformations · Changelog
description: >
  Control which sources can be used for original media when requesting
  transformations.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-05-14-media-transformations-origin-restrictions/
  md: https://developers.cloudflare.com/changelog/2025-05-14-media-transformations-origin-restrictions/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Introducing Origin Restrictions for Media Transformations

May 14, 2025

[Stream](https://developers.cloudflare.com/stream/)

We are adding [source origin restrictions](https://developers.cloudflare.com/stream/transform-videos/sources/) to the Media Transformations beta. This allows customers to restrict what sources can be used to fetch images and video for transformations. This feature is the same as --- and uses the same settings as --- [Image Transformations sources](https://developers.cloudflare.com/images/transform-images/sources/).

When transformations is first enabled, the default setting only allows transformations on images and media from the same website or domain being used to make the transformation request. In other words, by default, requests to `example.com/cdn-cgi/media` can only reference originals on `example.com`.

![Enable allowed origins from the Cloudflare dashboard](https://developers.cloudflare.com/_astro/allowed-origins.4hu5lHws_1geX4Q.webp)

Adding access to other sources, or allowing any source, [is easy to do](https://developers.cloudflare.com/images/transform-images/sources/) in the **Transformations** tab under **Stream**. Click each domain enabled for Transformations and set its sources list to match the needs of your content. The user making this change will need permission to edit zone settings.

For more information, learn about [Transforming Videos](https://developers.cloudflare.com/stream/transform-videos/).
