---
title: Build MCP servers with the Agents SDK · Changelog
description: The Agents SDK now includes built-in support for building remote
  MCP servers directly as part of your Agent.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-04-07-mcp-servers-agents-sdk-updates/
  md: https://developers.cloudflare.com/changelog/2025-04-07-mcp-servers-agents-sdk-updates/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Build MCP servers with the Agents SDK

Apr 07, 2025

[Agents ](https://developers.cloudflare.com/agents/)[Workers](https://developers.cloudflare.com/workers/)

The Agents SDK now includes built-in support for building remote MCP (Model Context Protocol) servers directly as part of your Agent. This allows you to easily create and manage MCP servers, without the need for additional infrastructure or configuration.

The SDK includes a new `MCPAgent` class that extends the `Agent` class and allows you to expose resources and tools over the MCP protocol, as well as authorization and authentication to enable remote MCP servers.

* JavaScript

  ```js
  export class MyMCP extends McpAgent {
    server = new McpServer({
      name: "Demo",
      version: "1.0.0",
    });


    async init() {
      this.server.resource(`counter`, `mcp://resource/counter`, (uri) => {
        // ...
      });


      this.server.tool(
        "add",
        "Add two numbers together",
        { a: z.number(), b: z.number() },
        async ({ a, b }) => {
          // ...
        },
      );
    }
  }
  ```

* TypeScript

  ```ts
  export class MyMCP extends McpAgent<Env> {
    server = new McpServer({
      name: "Demo",
      version: "1.0.0",
    });


    async init() {
      this.server.resource(`counter`, `mcp://resource/counter`, (uri) => {
        // ...
      });


      this.server.tool(
        "add",
        "Add two numbers together",
        { a: z.number(), b: z.number() },
        async ({ a, b }) => {
          // ...
        },
      );
    }
  }
  ```

See [the example](https://github.com/cloudflare/agents/tree/main/examples/mcp) for the full code and as the basis for building your own MCP servers, and the [client example](https://github.com/cloudflare/agents/tree/main/examples/mcp-client) for how to build an Agent that acts as an MCP client.

To learn more, review the [announcement blog](https://blog.cloudflare.com/building-ai-agents-with-mcp-authn-authz-and-durable-objects) as part of Developer Week 2025.

#### Agents SDK updates

We've made a number of improvements to the [Agents SDK](https://developers.cloudflare.com/agents/), including:

* Support for building MCP servers with the new `MCPAgent` class.
* The ability to export the current agent, request and WebSocket connection context using `import { context } from "agents"`, allowing you to minimize or avoid direct dependency injection when calling tools.
* Fixed a bug that prevented query parameters from being sent to the Agent server from the `useAgent` React hook.
* Automatically converting the `agent` name in `useAgent` or `useAgentChat` to kebab-case to ensure it matches the naming convention expected by [`routeAgentRequest`](https://developers.cloudflare.com/agents/api-reference/calling-agents/#calling-your-agent).

To install or update the Agents SDK, run `npm i agents@latest` in an existing project, or explore the `agents-starter` project:

```sh
npm create cloudflare@latest -- --template cloudflare/agents-starter
```

See the full release notes and changelog [on the Agents SDK repository](https://github.com/cloudflare/agents/blob/main/packages/agents/CHANGELOG.md) and
