---
title: Verified bots · Cloudflare bot solutions docs
description: A verified bot is a bot which has been added to Cloudflare's list
  of verified bots.
lastUpdated: 2025-10-15T15:50:02.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/concepts/bot/verified-bots/
  md: https://developers.cloudflare.com/bots/concepts/bot/verified-bots/index.md
---

A verified bot is a bot which has been added to Cloudflare's list of verified bots.

You can request for your bot to be added to Cloudflare's bots and agents directory by filling out an [online application](https://dash.cloudflare.com/?to=/:account/configurations/verified-bots) in the Cloudflare dashboard.

Note

A bot cannot be registered as both a verified bot and a signed agent. Review Cloudflare's [signed agents](https://developers.cloudflare.com/bots/concepts/bot/signed-agents/) to determine how to identify your bot.

## Verified bot requirement

For a bot to be verified, it must meet the following requirements:

1. The bot must follow [verified bots policy](https://developers.cloudflare.com/bots/concepts/bot/verified-bots/policy/).

2. The bot must be verified using one of the following verification methods:

   * [Web Bot Auth](https://developers.cloudflare.com/bots/reference/bot-verification/web-bot-auth/)
   * [IP validation](https://developers.cloudflare.com/bots/reference/bot-verification/ip-validation/)

Once Cloudflare approves a verified bot, it should appear on [Cloudflare Radar's bots and agents directory](https://radar.cloudflare.com/verified-bots).

***

## Transient false negatives

Once Cloudflare lists a bot as a verified bot, this entry is cached and may get delisted if no traffic is seen in the Cloudflare network coming from the bot for a defined period of time.

It takes 24 hours for an inactive IP to be removed as a verified bot.

A bot can remain unlisted until Cloudflare sees traffic being sourced from the bot. When the bot is revalidated, it is listed as a verified bot again.

***

## Verification methods

The bot must be verified using one of the following validation methods:

* [Web Bot Auth](https://developers.cloudflare.com/bots/reference/bot-verification/web-bot-auth/)
* [IP validation](https://developers.cloudflare.com/bots/reference/bot-verification/ip-validation/)

***

## Categories

You can segment your verified bot traffic by its type and purpose by adding the Verified Bot Categories field `cf.verified_bot_category` as a filter criteria in [WAF Custom rules](https://developers.cloudflare.com/waf/custom-rules/), [Advanced Rate Limiting](https://developers.cloudflare.com/waf/rate-limiting-rules/), and Late Transform rules.

Warning

The Verified Bot Categories field is not compatible with legacy Firewall rules.

Note

Verified Bot Categories is available on all plans.

| Name | String value | Example |
| - | - | - |
| Academic research | `Academic Research` | Library of Congress, TurnItInBot, Bibliothèque nationale de France |
| Accessibility | `Accessibility` | Accessible Web Bot |
| Advertising or marketing | `Advertising & Marketing` | Google Adsbot |
| Aggregators | `Aggregator` | Pinterest, Indeed Jobsbot |
| AI Assistant | `AI Assistant` | Perplexity-User, DuckAssistBot |
| AI Crawler | `AI Crawler` | Google Bard, ChatGPT bot |
| AI Search | `AI Search` | OAI-SearchBot |
| Archiver | `Archiver` | Internet Archive, CommonCrawl |
| Feed fetcher | `Feed Fetcher` | RSS or Podcast feed updaters |
| Monitoring or analytics | `Monitoring & Analytics` | Uptime Monitors |
| Page preview | `Page Preview` | Facebook, Slack, Twitter, or Discord Link Preview tools |
| Search engine crawler | `Search Engine Crawler` | Googlebot, Bingbot, Yandexbot, Baidubot |
| Search engine optimization | `Search Engine Optimization` | Google Lighthouse, GT Metrix, Pingdom, AddThis |
| Security | `Security` | Vulnerability Scanners, SSL Domain Control Validation (DCV) Check Tools |
| Social media marketing | `Social Media Marketing` | Brandwatch |
| Webhooks | `Webhooks` | Payment processors, WordPress Integration tools |
| Other | `Other` | |

### Known issues

The Yandex bot is classified as a Verified Bot, but traffic may occasionally be blocked by a [WAF Managed Rule](https://developers.cloudflare.com/waf/managed-rules/) (such as the rule with ID `...f6cbb163`).

This typically occurs when Yandex updates its source IP address ranges. The new IPs are temporarily unrecognized by the WAF Managed Rules until the updated Verified Bot IP list is fully synchronized across the Cloudflare network.

To restore Yandex traffic, deploy a [WAF exception](https://developers.cloudflare.com/waf/managed-rules/waf-exceptions/) that temporarily skips the managed rule with ID `<RuleID id="2854e3f18ad946049e6d90ccf6cbb163" />` when a request is coming from the **Yandex IP** and the user-agent contains **Yandex**. This ensures that legitimate Yandex traffic bypasses the blocking rule without disabling security features for other traffic.

You can also create a [WAF Custom Rule](https://developers.cloudflare.com/waf/custom-rules/skip/) with the *Skip* action targeting the managed ruleset that contains the blocking rule. The rule expression should specifically match the request's Yandex IP and User-Agent.

The issue is transient and will resolve automatically once the new Yandex IP addresses are fully propagated to Cloudflare's systems. This propagation typically takes up to 48 hours. If the bot remains blocked after 48 hours, contact [Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/).

***

## Availability

Verified bots are excluded by default when [Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/bot-fight-mode/) is enabled to block definite bots.

[Super Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/super-bot-fight-mode/) and [Enterprise Bot Management](https://developers.cloudflare.com/bots/get-started/bot-management/) customers have the option to block or allow verified bots.
